/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Collection.CreateCollection", category="Document", label="Create a collection", description="Create a new collection. This is returning the document serialization of the created collection.")
public class CreateCollectionOperation {
    public static final String ID = "Collection.CreateCollection";
    @Context
    protected CoreSession session;
    @Context
    protected CollectionManager collectionManager;
    @Param(name="name")
    protected String name;
    @Param(name="description", required=false)
    protected String description;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws ClientException {
        return this.collectionManager.createCollection(this.session, this.name, this.description, doc.getPathAsString());
    }

    @OperationMethod
    public DocumentModel run() throws ClientException {
        return this.collectionManager.createCollection(this.session, this.name, this.description, null);
    }
}

