/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.freemarker;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.services.permalink.PermaLinkService;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.nuxeo.ecm.automation.features.PlatformFunctions;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBlob;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeFunctions
extends PlatformFunctions {
    private static final String PROTOCOL_BASE_URL = "http://";
    private static CommentManager commentManager;
    private static PermaLinkService permaLinkService;

    public String getDownloadFileUrl(DocumentModel doc, String xpath) throws PropertyException, ClientException {
        BlobProperty blob = (BlobProperty)doc.getProperty(xpath);
        String filename = ((SQLBlob)blob.getValue()).getFilename();
        String url = DocumentModelFunctions.fileUrl((String)"downloadFile", (DocumentModel)doc, (String)xpath, (String)filename);
        return url;
    }

    public String getPermalink(DocumentModel doc) throws PropertyException, ClientException {
        String url = "";
        if (ToutaticeDocumentHelper.isVisibleInPortal(doc, doc.getCoreSession())) {
            if (null == permaLinkService) {
                try {
                    permaLinkService = (PermaLinkService)Framework.getService(PermaLinkService.class);
                }
                catch (Exception e) {
                    throw new WebException("Unable to get publicationService");
                }
            }
            url = permaLinkService.getPermalink(doc);
        }
        return url;
    }

    public String getPortalHost(DocumentModel doc) {
        String host = "";
        if (ToutaticeDocumentHelper.isVisibleInPortal(doc, doc.getCoreSession())) {
            if (null == permaLinkService) {
                try {
                    permaLinkService = (PermaLinkService)Framework.getService(PermaLinkService.class);
                }
                catch (Exception e) {
                    throw new WebException("Unable to get publicationService");
                }
            }
            host = permaLinkService.getPortalHost();
        }
        return host;
    }

    public String getShortPortalHost(String portalHost) {
        String shortHost = "";
        if (StringUtils.isNotBlank((String)portalHost)) {
            shortHost = StringUtils.substring((String)portalHost, (int)PROTOCOL_BASE_URL.length());
        }
        return shortHost;
    }

    public String getDocumentComments(DocumentModel doc, Integer noComment) throws Exception {
        String res = "";
        if (commentManager == null) {
            commentManager = this.getCommentManager();
        }
        List lstComments = commentManager.getComments(doc);
        int idxComment = lstComments.size() - 1;
        if (noComment != null && noComment < lstComments.size()) {
            idxComment = noComment;
        }
        DocumentModel derComment = (DocumentModel)lstComments.get(idxComment);
        res = (String)((Object)derComment.getPropertyValue("comment:text"));
        return res;
    }

    private CommentManager getCommentManager() throws Exception {
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        if (commentManager == null) {
            throw new WebException("Unable to get commentManager");
        }
        return commentManager;
    }

    public String extractTextFromHTML(String html) {
        return Jsoup.parse((String)html).text();
    }

    public String getUserFullName(String username) {
        String fullName = "";
        try {
            NuxeoPrincipal principal = super.getUserManager().getPrincipal(username);
            if (principal != null) {
                fullName = principal.getFirstName().concat(" ").concat(principal.getLastName());
            }
        }
        catch (Exception e) {
            return fullName;
        }
        return fullName;
    }
}

