/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert.impl;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.base64.Base64;
import com.phloc.commons.base64.Base64Helper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.typeconvert.ITypeConverter;
import com.phloc.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.phloc.commons.typeconvert.ITypeConverterRegistry;
import com.phloc.commons.typeconvert.TypeConverter;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRuleAnySourceFixedDestination;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class CollectionTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(ArrayList.class){

            @Override
            public ArrayList<?> convert(@Nonnull Object object) {
                if (object instanceof Collection) {
                    return new ArrayList((Collection)object);
                }
                ArrayList<Object> arrayList = new ArrayList<Object>(1);
                arrayList.add(object);
                return arrayList;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Vector.class){

            @Override
            public Vector<?> convert(@Nonnull Object object) {
                if (object instanceof Collection) {
                    return new Vector((Collection)object);
                }
                Vector<Object> vector = new Vector<Object>(1);
                vector.add(object);
                return vector;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(LinkedList.class){

            @Override
            public LinkedList<?> convert(@Nonnull Object object) {
                if (object instanceof Collection) {
                    return new LinkedList((Collection)object);
                }
                LinkedList<Object> linkedList = new LinkedList<Object>();
                linkedList.add(object);
                return linkedList;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(CopyOnWriteArrayList.class){

            @Override
            public CopyOnWriteArrayList<?> convert(@Nonnull Object object) {
                if (object instanceof Collection) {
                    return new CopyOnWriteArrayList((Collection)object);
                }
                CopyOnWriteArrayList<Object> copyOnWriteArrayList = new CopyOnWriteArrayList<Object>();
                copyOnWriteArrayList.add(object);
                return copyOnWriteArrayList;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(List.class){

            @Override
            public List<?> convert(@Nonnull Object object) {
                if (object instanceof Collection) {
                    return ContainerHelper.newList((Collection)object);
                }
                return ContainerHelper.newList(object);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(TreeSet.class){

            @Override
            public TreeSet<?> convert(@Nonnull Object object) {
                if (object instanceof Collection) {
                    return new TreeSet((Collection)object);
                }
                TreeSet<Object> treeSet = new TreeSet<Object>();
                treeSet.add(object);
                return treeSet;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(LinkedHashSet.class){

            @Override
            public LinkedHashSet<?> convert(@Nonnull Object object) {
                if (object instanceof Collection) {
                    return new LinkedHashSet((Collection)object);
                }
                LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(1);
                linkedHashSet.add(object);
                return linkedHashSet;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(CopyOnWriteArraySet.class){

            @Override
            public CopyOnWriteArraySet<?> convert(@Nonnull Object object) {
                if (object instanceof Collection) {
                    return new CopyOnWriteArraySet((Collection)object);
                }
                CopyOnWriteArraySet<Object> copyOnWriteArraySet = new CopyOnWriteArraySet<Object>();
                copyOnWriteArraySet.add(object);
                return copyOnWriteArraySet;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Set.class){

            @Override
            public Set<?> convert(@Nonnull Object object) {
                if (object instanceof Collection) {
                    return ContainerHelper.newSet((Collection)object);
                }
                return ContainerHelper.newSet(object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Boolean> convert(@Nonnull Object object) {
                return ContainerHelper.newBooleanList((boolean[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Boolean> convert(@Nonnull Object object) {
                return ContainerHelper.newBooleanVector((boolean[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Boolean> convert(@Nonnull Object object) {
                return ContainerHelper.newBooleanSet((boolean[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Boolean> convert(@Nonnull Object object) {
                return ContainerHelper.newBooleanOrderedSet((boolean[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(boolean[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Boolean> convert(@Nonnull Object object) {
                return ContainerHelper.newBooleanSortedSet((boolean[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(byte[].class, String.class, new ITypeConverter(){

            @Override
            public String convert(@Nonnull Object object) {
                return Base64.encodeBytes((byte[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(String.class, byte[].class, new ITypeConverter(){

            @Override
            public byte[] convert(@Nonnull Object object) {
                return Base64Helper.safeDecode((String)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(byte[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Byte> convert(@Nonnull Object object) {
                return ContainerHelper.newByteList((byte[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(byte[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Byte> convert(@Nonnull Object object) {
                return ContainerHelper.newByteVector((byte[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(byte[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Byte> convert(@Nonnull Object object) {
                return ContainerHelper.newByteSet((byte[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(byte[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Byte> convert(@Nonnull Object object) {
                return ContainerHelper.newByteOrderedSet((byte[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(byte[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Byte> convert(@Nonnull Object object) {
                return ContainerHelper.newByteSortedSet((byte[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(char[].class, String.class, new ITypeConverter(){

            @Override
            public String convert(@Nonnull Object object) {
                return new String((char[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(String.class, char[].class, new ITypeConverter(){

            @Override
            public char[] convert(@Nonnull Object object) {
                return ((String)object).toCharArray();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(char[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Character> convert(@Nonnull Object object) {
                return ContainerHelper.newCharList((char[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(char[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Character> convert(@Nonnull Object object) {
                return ContainerHelper.newCharVector((char[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(char[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Character> convert(@Nonnull Object object) {
                return ContainerHelper.newCharSet((char[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(char[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Character> convert(@Nonnull Object object) {
                return ContainerHelper.newCharOrderedSet((char[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(char[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Character> convert(@Nonnull Object object) {
                return ContainerHelper.newCharSortedSet((char[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(double[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Double> convert(@Nonnull Object object) {
                return ContainerHelper.newDoubleList((double[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(double[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Double> convert(@Nonnull Object object) {
                return ContainerHelper.newDoubleVector((double[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(double[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Double> convert(@Nonnull Object object) {
                return ContainerHelper.newDoubleSet((double[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(double[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Double> convert(@Nonnull Object object) {
                return ContainerHelper.newDoubleOrderedSet((double[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(double[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Double> convert(@Nonnull Object object) {
                return ContainerHelper.newDoubleSortedSet((double[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(float[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Float> convert(@Nonnull Object object) {
                return ContainerHelper.newFloatList((float[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(float[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Float> convert(@Nonnull Object object) {
                return ContainerHelper.newFloatVector((float[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(float[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Float> convert(@Nonnull Object object) {
                return ContainerHelper.newFloatSet((float[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(float[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Float> convert(@Nonnull Object object) {
                return ContainerHelper.newFloatOrderedSet((float[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(float[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Float> convert(@Nonnull Object object) {
                return ContainerHelper.newFloatSortedSet((float[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(int[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Integer> convert(@Nonnull Object object) {
                return ContainerHelper.newIntList((int[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(int[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Integer> convert(@Nonnull Object object) {
                return ContainerHelper.newIntVector((int[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(int[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Integer> convert(@Nonnull Object object) {
                return ContainerHelper.newIntSet((int[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(int[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Integer> convert(@Nonnull Object object) {
                return ContainerHelper.newIntOrderedSet((int[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(int[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Integer> convert(@Nonnull Object object) {
                return ContainerHelper.newIntSortedSet((int[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(long[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Long> convert(@Nonnull Object object) {
                return ContainerHelper.newLongList((long[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(long[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Long> convert(@Nonnull Object object) {
                return ContainerHelper.newLongVector((long[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(long[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Long> convert(@Nonnull Object object) {
                return ContainerHelper.newLongSet((long[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(long[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Long> convert(@Nonnull Object object) {
                return ContainerHelper.newLongOrderedSet((long[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(long[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Long> convert(@Nonnull Object object) {
                return ContainerHelper.newLongSortedSet((long[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(short[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Short> convert(@Nonnull Object object) {
                return ContainerHelper.newShortList((short[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(short[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Short> convert(@Nonnull Object object) {
                return ContainerHelper.newShortVector((short[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(short[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Short> convert(@Nonnull Object object) {
                return ContainerHelper.newShortSet((short[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(short[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Short> convert(@Nonnull Object object) {
                return ContainerHelper.newShortOrderedSet((short[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(short[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Short> convert(@Nonnull Object object) {
                return ContainerHelper.newShortSortedSet((short[])object);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(boolean[].class){

            @Override
            public boolean[] convert(@Nonnull Object object) {
                boolean[] blArray;
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    int n = Array.getLength(object);
                    blArray = new boolean[n];
                    for (int i = 0; i < n; ++i) {
                        Object object2 = Array.get(object, i);
                        blArray[i] = TypeConverter.convertToBoolean(object2);
                    }
                } else if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    blArray = new boolean[collection.size()];
                    int n = 0;
                    for (Object e : collection) {
                        blArray[n++] = TypeConverter.convertToBoolean(e);
                    }
                } else {
                    blArray = new boolean[]{TypeConverter.convertToBoolean(object)};
                }
                return blArray;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(byte[].class){

            @Override
            public byte[] convert(@Nonnull Object object) {
                byte[] byArray;
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    int n = Array.getLength(object);
                    byArray = new byte[n];
                    for (int i = 0; i < n; ++i) {
                        Object object2 = Array.get(object, i);
                        byArray[i] = TypeConverter.convertToByte(object2);
                    }
                } else if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    byArray = new byte[collection.size()];
                    int n = 0;
                    for (Object e : collection) {
                        byArray[n++] = TypeConverter.convertToByte(e);
                    }
                } else {
                    byArray = new byte[]{TypeConverter.convertToByte(object)};
                }
                return byArray;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(char[].class){

            @Override
            public char[] convert(@Nonnull Object object) {
                char[] cArray;
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    int n = Array.getLength(object);
                    cArray = new char[n];
                    for (int i = 0; i < n; ++i) {
                        Object object2 = Array.get(object, i);
                        cArray[i] = TypeConverter.convertToChar(object2);
                    }
                } else if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    cArray = new char[collection.size()];
                    int n = 0;
                    for (Object e : collection) {
                        cArray[n++] = TypeConverter.convertToChar(e);
                    }
                } else {
                    cArray = new char[]{TypeConverter.convertToChar(object)};
                }
                return cArray;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(double[].class){

            @Override
            public double[] convert(@Nonnull Object object) {
                double[] dArray;
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    int n = Array.getLength(object);
                    dArray = new double[n];
                    for (int i = 0; i < n; ++i) {
                        Object object2 = Array.get(object, i);
                        dArray[i] = TypeConverter.convertToDouble(object2);
                    }
                } else if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    dArray = new double[collection.size()];
                    int n = 0;
                    for (Object e : collection) {
                        dArray[n++] = TypeConverter.convertToDouble(e);
                    }
                } else {
                    dArray = new double[]{TypeConverter.convertToDouble(object)};
                }
                return dArray;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(float[].class){

            @Override
            public float[] convert(@Nonnull Object object) {
                float[] fArray;
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    int n = Array.getLength(object);
                    fArray = new float[n];
                    for (int i = 0; i < n; ++i) {
                        Object object2 = Array.get(object, i);
                        fArray[i] = TypeConverter.convertToFloat(object2);
                    }
                } else if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    fArray = new float[collection.size()];
                    int n = 0;
                    for (Object e : collection) {
                        fArray[n++] = TypeConverter.convertToFloat(e);
                    }
                } else {
                    fArray = new float[]{TypeConverter.convertToFloat(object)};
                }
                return fArray;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(int[].class){

            @Override
            public int[] convert(@Nonnull Object object) {
                int[] nArray;
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    int n = Array.getLength(object);
                    nArray = new int[n];
                    for (int i = 0; i < n; ++i) {
                        Object object2 = Array.get(object, i);
                        nArray[i] = TypeConverter.convertToInt(object2);
                    }
                } else if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    nArray = new int[collection.size()];
                    int n = 0;
                    for (Object e : collection) {
                        nArray[n++] = TypeConverter.convertToInt(e);
                    }
                } else {
                    nArray = new int[]{TypeConverter.convertToInt(object)};
                }
                return nArray;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(long[].class){

            @Override
            public long[] convert(@Nonnull Object object) {
                long[] lArray;
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    int n = Array.getLength(object);
                    lArray = new long[n];
                    for (int i = 0; i < n; ++i) {
                        Object object2 = Array.get(object, i);
                        lArray[i] = TypeConverter.convertToLong(object2);
                    }
                } else if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    lArray = new long[collection.size()];
                    int n = 0;
                    for (Object e : collection) {
                        lArray[n++] = TypeConverter.convertToLong(e);
                    }
                } else {
                    lArray = new long[]{TypeConverter.convertToLong(object)};
                }
                return lArray;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(short[].class){

            @Override
            public short[] convert(@Nonnull Object object) {
                short[] sArray;
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    int n = Array.getLength(object);
                    sArray = new short[n];
                    for (int i = 0; i < n; ++i) {
                        Object object2 = Array.get(object, i);
                        sArray[i] = TypeConverter.convertToShort(object2);
                    }
                } else if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    sArray = new short[collection.size()];
                    int n = 0;
                    for (Object e : collection) {
                        sArray[n++] = TypeConverter.convertToShort(e);
                    }
                } else {
                    sArray = new short[]{TypeConverter.convertToShort(object)};
                }
                return sArray;
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(String[].class){

            @Override
            public String[] convert(@Nonnull Object object) {
                String[] stringArray;
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    int n = Array.getLength(object);
                    stringArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        Object object2 = Array.get(object, i);
                        stringArray[i] = TypeConverter.convertIfNecessary(object2, String.class);
                    }
                } else if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    stringArray = new String[collection.size()];
                    int n = 0;
                    for (Object e : collection) {
                        stringArray[n++] = TypeConverter.convertIfNecessary(e, String.class);
                    }
                } else {
                    stringArray = new String[]{TypeConverter.convertIfNecessary(object, String.class)};
                }
                return stringArray;
            }
        });
    }
}

