/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.util.ArrayList;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.PutDocumentInTrash", category="Document", label="PutDocumentInTrash", description="Put a document in trash.")
public class PutDocumentInTrash {
    public static final String ID = "Document.PutDocumentInTrash";
    @Context
    protected CoreSession session;
    @Param(name="document", required=true)
    protected DocumentModel document;

    @OperationMethod
    public Object run() throws Exception {
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>(1);
        docs.add(this.document);
        DocumentModel proxy = ToutaticeDocumentHelper.getProxy((CoreSession)this.session, (DocumentModel)this.document, null, (boolean)true);
        if (proxy != null) {
            this.session.removeDocument(proxy.getRef());
        }
        TrashService trashService = (TrashService)Framework.getService(TrashService.class);
        trashService.trashDocuments(docs);
        return this.document;
    }
}

