/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.In;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Operation(id="Document.SetWebId", category="Document", label="Set webid.", description="Check unicity of webid and apply to the document in current domain..")
public class SetWebID {
    public static final String ID = "Document.SetWebId";
    private static final Log log = LogFactory.getLog(SetWebID.class);
    private static final String NO_RECURSIVE_CHAIN = "notRecursive";
    private static final String WEB_ID_UNICITY_QUERY = "select * from Document Where ttc:webid = \"%s\" AND ecm:uuid <> '%s' AND ecm:isProxy = 0 AND ecm:currentLifeCycleState!='deleted' AND ecm:isCheckedInVersion = 0";
    private static final List<Class<?>> FILTERED_SERVICES_LIST = new ArrayList<Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(EventService.class);
            this.add(VersioningService.class);
        }
    };
    @Context
    protected CoreSession coreSession;
    @In(create=true)
    protected NavigationContext navigationContext;
    @Param(name="chainSource", required=false)
    protected String chainSource;

    @OperationMethod
    public DocumentModel run(DocumentModel document) throws Exception {
        UnrestrictedSilentSetWebIdRunner runner = new UnrestrictedSilentSetWebIdRunner(this.coreSession, document);
        runner.silentRun(true, FILTERED_SERVICES_LIST);
        return runner.getDocument();
    }

    private class UnrestrictedSilentSetWebIdRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel document;
        private DocumentModel parentDoc;

        protected UnrestrictedSilentSetWebIdRunner(CoreSession session, DocumentModel document) {
            super(session);
            this.document = document;
        }

        public DocumentModel getDocument() {
            return this.parentDoc != null ? this.parentDoc : this.document;
        }

        public void run() throws ClientException {
            DocumentRef parentRef;
            String webid = null;
            String extension = null;
            boolean hasToBeUpdated = false;
            if (this.document.isImmutable() || !this.document.hasSchema("toutatice")) {
                return;
            }
            if (StringUtils.isNotBlank((String)this.getWebId())) {
                webid = this.getWebId().toString();
                webid = IdUtils.generateId((String)webid, (String)"-", (boolean)true, (int)24);
            } else if (StringUtils.isBlank((String)this.getWebId())) {
                int lastIndexOf;
                webid = this.generateNewWebId();
                if (("File".equals(this.document.getType()) || "Picture".equals(this.document.getType())) && (lastIndexOf = this.document.getTitle().lastIndexOf(".")) > -1 && webid.endsWith(extension = this.document.getTitle().substring(lastIndexOf + 1, this.document.getTitle().length()))) {
                    webid = webid.substring(0, webid.length() - extension.length() - 1);
                }
                hasToBeUpdated = true;
            }
            if (webid != null && webid.length() > 0) {
                boolean unicity = true;
                Integer suffix = null;
                String webidconcat = webid;
                do {
                    DocumentModelList query;
                    if ((query = this.session.query(String.format(SetWebID.WEB_ID_UNICITY_QUERY, webidconcat = StringEscapeUtils.escapeJava((String)webidconcat), this.document.getId()))).size() > 0) {
                        unicity = false;
                        suffix = suffix == null ? Integer.valueOf(1) : Integer.valueOf(suffix + 1);
                        webidconcat = webid.concat(suffix.toString());
                        continue;
                    }
                    unicity = true;
                    if (webid.equals(webidconcat)) continue;
                    webid = webidconcat;
                    hasToBeUpdated = true;
                } while (!unicity);
                if (hasToBeUpdated) {
                    log.info((Object)("Id relocated to " + webid + " for document " + this.document.getPathAsString()));
                    this.document.setPropertyValue("ttc:webid", (Serializable)((Object)webid));
                    if (extension != null) {
                        this.document.setPropertyValue("ttc:extensionUrl", (Serializable)((Object)extension));
                    }
                    this.session.saveDocument(this.document);
                }
            }
            if (!StringUtils.equals((String)SetWebID.this.chainSource, (String)SetWebID.NO_RECURSIVE_CHAIN) && this.session.hasChildren(parentRef = this.document.getRef())) {
                if (this.parentDoc == null) {
                    this.parentDoc = this.document;
                }
                Iterator iterator = this.session.getChildren(parentRef).iterator();
                while (iterator.hasNext()) {
                    DocumentModel child;
                    this.document = child = (DocumentModel)iterator.next();
                    this.run();
                }
            }
        }

        private String getWebId() {
            return (String)((Object)this.document.getPropertyValue("ttc:webid"));
        }

        private String generateNewWebId() {
            String[] arrayPath = this.document.getPathAsString().split("/");
            String webid = arrayPath[arrayPath.length - 1];
            if (webid.contains(".")) {
                webid = webid.substring(0, webid.indexOf("."));
            }
            return webid;
        }
    }
}

