/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.comments;

import fr.toutatice.ecm.platform.automation.comments.FetchCommentsOfDocument;
import java.security.Principal;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.comment.api.CommentableDocument;
import org.nuxeo.ecm.platform.comment.workflow.utils.FollowTransitionUnrestricted;

@Operation(id="Document.AddComment", category="Document", label="AddCommentToDocument", description="Add a comment to a (commentable) document")
public class AddComment {
    public static final String ID = "Document.AddComment";
    public static final String COMMENT_TYPE = "Comment";
    public static final String THREAD_TYPE = "Thread";
    public static final String POST_TYPE = "Post";
    public static final String PUBLISHED_TRANSITION = "moderation_publish";
    @Context
    protected CoreSession session;
    @Param(name="commentableDoc", required=true)
    protected DocumentModel document;
    @Param(name="comment", required=true)
    protected String commentContent;
    @Param(name="title", required=false)
    protected String commentTitle;
    @Param(name="fileName", required=false)
    protected String fileName;

    @OperationMethod
    public DocumentModel run() throws Exception {
        CommentableDocument commentableDoc = (CommentableDocument)this.document.getAdapter(CommentableDocument.class);
        DocumentModel comment = AddComment.createComment(this.document.getType(), this.session, this.commentContent, this.commentTitle, this.fileName, null);
        return commentableDoc.addComment(comment);
    }

    @OperationMethod
    public Object run(Blob blob) throws Exception {
        Boolean isModerated;
        CommentableDocument commentableDoc = (CommentableDocument)this.document.getAdapter(CommentableDocument.class);
        DocumentModel comment = AddComment.createComment(this.document.getType(), this.session, this.commentContent, this.commentTitle, this.fileName, blob);
        DocumentModel commentDoc = commentableDoc.addComment(comment);
        if (THREAD_TYPE.equals(this.document.getType()) && !(isModerated = (Boolean)this.document.getProperty("thread", "moderated")).booleanValue()) {
            FollowTransitionUnrestricted transition = new FollowTransitionUnrestricted(this.session, commentDoc.getRef(), PUBLISHED_TRANSITION);
            transition.runUnrestricted();
        }
        return new StringBlob(commentDoc.getId());
    }

    public static DocumentModel createComment(String docType, CoreSession session, String commentContent, String commentTitle, String fileName, Blob blob) throws ClientException {
        String commentType = AddComment.getType(docType);
        String schemaPrefix = FetchCommentsOfDocument.getSchema(docType);
        DocumentModel comment = session.createDocumentModel(commentType);
        Principal user = session.getPrincipal();
        if (user == null) {
            throw new ClientException("No author for comment.");
        }
        comment.setProperty(schemaPrefix, "author", (Object)user.getName());
        comment.setProperty(schemaPrefix, "text", (Object)commentContent);
        comment.setProperty(schemaPrefix, "creationDate", (Object)Calendar.getInstance());
        if (POST_TYPE.equals(commentType)) {
            comment.setProperty(schemaPrefix, "title", (Object)commentTitle);
            comment.setProperty("comment", "author", (Object)user.getName());
            if (StringUtils.isNotEmpty((String)fileName)) {
                comment.setProperty("post", "filename", (Object)fileName);
                comment.setProperty("post", "fileContent", (Object)blob);
            }
        }
        return comment;
    }

    protected static String getType(String documentType) {
        String type = COMMENT_TYPE;
        if (THREAD_TYPE.equals(documentType)) {
            type = POST_TYPE;
        }
        return type;
    }
}

