/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.comments;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.comment.api.CommentableDocument;

@Operation(id="Fetch.DocumentComments", category="Fetch", label="FetchCommentsOfDocument", description="Fetches comments of a (commentable) document")
public class FetchCommentsOfDocument {
    public static final String ID = "Fetch.DocumentComments";
    private static final Log log = LogFactory.getLog(FetchCommentsOfDocument.class);
    public static final String COMMENT_SCHEMA = "comment";
    public static final String POST_SCHEMA = "post";
    @Context
    CoreSession session;
    @Param(name="commentableDoc", required=true)
    protected DocumentModel document;

    @OperationMethod
    public Object run() throws ClientException, IOException {
        List commentsRoots;
        JSONArray commentsTree = new JSONArray();
        CommentableDocument commentableDoc = (CommentableDocument)this.document.getAdapter(CommentableDocument.class);
        String schemaPrefix = COMMENT_SCHEMA;
        if ("Thread".equals(this.document.getType())) {
            schemaPrefix = POST_SCHEMA;
        }
        if ((commentsRoots = commentableDoc.getComments()) != null) {
            for (DocumentModel commentRoot : commentsRoots) {
                JSONObject jsonCommentRoot = new JSONObject();
                jsonCommentRoot.element("id", (Object)commentRoot.getId());
                jsonCommentRoot.element("path", (Object)commentRoot.getPathAsString());
                String author = (String)commentRoot.getProperty(schemaPrefix, "author");
                jsonCommentRoot.element("author", (Object)author);
                jsonCommentRoot.element("creationDate", commentRoot.getProperty(schemaPrefix, "creationDate"));
                jsonCommentRoot.element("content", commentRoot.getProperty(schemaPrefix, "text"));
                jsonCommentRoot.element("modifiedDate", commentRoot.getProperty("dublincore", "modified"));
                boolean canDelete = this.canDeleteComment(author, this.document);
                jsonCommentRoot.element("canDelete", canDelete);
                if ("Thread".equals(this.document.getType())) {
                    jsonCommentRoot.element("title", commentRoot.getProperty(schemaPrefix, "title"));
                    jsonCommentRoot.element("filename", commentRoot.getProperty(schemaPrefix, "filename"));
                }
                jsonCommentRoot.element("children", (Collection)this.getCommentsThread(commentRoot, commentableDoc, new JSONArray()));
                commentsTree.add((Object)jsonCommentRoot);
                if (!StringUtils.isBlank((String)author)) continue;
                log.warn((Object)("Missing comment author on comment ID '" + commentRoot.getId() + "' (content: '" + commentRoot.getProperty(schemaPrefix, "text") + "')"));
            }
        }
        return this.createBlob(commentsTree);
    }

    private JSONArray getCommentsThread(DocumentModel comment, CommentableDocument commentableDocService, JSONArray threads) throws ClientException {
        String schemaPrefix = FetchCommentsOfDocument.getSchema(this.document.getType());
        List childrenComments = commentableDocService.getComments(comment);
        if (childrenComments == null || childrenComments.isEmpty()) {
            return threads;
        }
        for (DocumentModel childComment : childrenComments) {
            JSONObject jsonChildComment = new JSONObject();
            jsonChildComment.element("id", (Object)childComment.getId());
            jsonChildComment.element("path", (Object)childComment.getPathAsString());
            String author = (String)childComment.getProperty(schemaPrefix, "author");
            jsonChildComment.element("author", (Object)author);
            jsonChildComment.element("creationDate", childComment.getProperty(schemaPrefix, "creationDate"));
            jsonChildComment.element("content", childComment.getProperty(schemaPrefix, "text"));
            jsonChildComment.element("modifiedDate", childComment.getProperty("dublincore", "modified"));
            boolean canDelete = this.canDeleteComment(author, this.document);
            jsonChildComment.element("canDelete", canDelete);
            if ("Thread".equals(this.document.getType())) {
                jsonChildComment.element("title", childComment.getProperty(schemaPrefix, "title"));
                jsonChildComment.element("filename", childComment.getProperty(schemaPrefix, "filename"));
            }
            jsonChildComment.element("children", (Collection)this.getCommentsThread(childComment, commentableDocService, new JSONArray()));
            threads.add((Object)jsonChildComment);
            if (!StringUtils.isBlank((String)author)) continue;
            log.warn((Object)("Missing comment author on comment ID '" + childComment.getId() + "' (content: '" + childComment.getProperty(schemaPrefix, "text") + "')"));
        }
        return threads;
    }

    private Blob createBlob(JSONArray json) {
        return new StringBlob(json.toString(), "application/json");
    }

    private boolean canDeleteComment(String author, DocumentModel document) {
        boolean canDelete = false;
        Principal user = this.session.getPrincipal();
        if (user != null) {
            boolean isUserAuthor = user.getName().equals(author);
            boolean isUserAdmin = ((NuxeoPrincipal)user).isAdministrator();
            boolean userHasAllRights = this.session.hasPermission(document.getRef(), "Everything");
            canDelete = isUserAuthor || isUserAdmin || userHasAllRights;
        }
        return canDelete;
    }

    protected static String getSchema(String documentType) {
        String schemaPrefix = COMMENT_SCHEMA;
        if ("Thread".equals(documentType)) {
            schemaPrefix = POST_SCHEMA;
        }
        return schemaPrefix;
    }
}

