/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.document;

import fr.toutatice.ecm.platform.automation.document.AbstractDublinCoreDocumentUpdate;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.IOException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;

@Operation(id="Document.TTCCreate", category="Document", label="Create a new document", description="Create a new document in the input folder. If the 'name' parameter is not set, a new name will be derived from the document title, using the same naming strategy as Nuxeo when using the GUI (if the document has a title). This is the only difference between this operation and 'Document.Create', with the latter defaulting the name to 'Untitled'.")
public class CreateDocument
extends AbstractDublinCoreDocumentUpdate {
    public static final String ID = "Document.TTCCreate";
    @Context
    protected CoreSession session;
    @Context
    protected PathSegmentService pathSegmentService;
    @Param(name="type")
    protected String type;
    @Param(name="name", required=false)
    protected String name;
    @Param(name="properties", required=false)
    protected Properties properties;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        if (this.name == null) {
            this.name = this.properties != null && this.properties.get((Object)"dc:title") != null ? this.pathSegmentService.generatePathSegment((String)this.properties.get((Object)"dc:title")) : "Untitled";
        }
        DocumentModel newDoc = this.session.createDocumentModel(doc.getPathAsString(), this.name, this.type);
        newDoc = this.properties != null ? super.executeSplittingProperties(this.session, newDoc, this.properties, true) : this.execute(this.session, newDoc, this.properties, true);
        return newDoc;
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef doc) throws Exception {
        return this.run(this.session.getDocument(doc));
    }

    @Override
    protected DocumentModel execute(CoreSession session, DocumentModel document, Properties properties, boolean save) throws ClientException, IOException {
        return session.createDocument(document);
    }

    @Override
    protected DocumentModel execute(CoreSession session, DocumentModel document, Properties properties, Properties dublinCoreProperties, boolean save) throws ClientException, IOException {
        DocumentHelper.setProperties((CoreSession)session, (DocumentModel)document, (Properties)properties);
        DocumentModel createDocument = session.createDocument(document);
        DocumentHelper.setProperties((CoreSession)session, (DocumentModel)createDocument, (Properties)dublinCoreProperties);
        ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)session, (DocumentModel)createDocument, (boolean)false);
        return createDocument;
    }
}

