/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.security;

import java.util.Collection;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="Document.GetACLs", category="Document", label="Gets document's ACLs", description="Gets document's ACLs")
public class GetDocumentACLs {
    public static final String ID = "Document.GetACLs";
    @Context
    protected CoreSession session;
    @Context
    protected UserManager userManager;

    @OperationMethod
    public Object run(DocumentModel document) throws ClientException {
        Object[] acLs;
        JSONObject allACLs = new JSONObject();
        ACP acp = this.session.getACP(document.getRef());
        if (acp != null && ArrayUtils.isNotEmpty((Object[])(acLs = acp.getACLs()))) {
            JSONArray inheritedACLs = new JSONArray();
            JSONArray localACLs = new JSONArray();
            for (Object acl : acLs) {
                if ("inherited".equals(acl.getName())) {
                    this.extractNSetACEs(inheritedACLs, (ACL)acl);
                    continue;
                }
                if (!"local".equals(acl.getName())) continue;
                this.extractNSetACEs(localACLs, (ACL)acl);
            }
            allACLs.element("inherited", (Collection)inheritedACLs);
            allACLs.element("local", (Collection)localACLs);
        }
        return new StringBlob(allACLs.toString(), "application/json");
    }

    protected void extractNSetACEs(JSONArray jsonACEs, ACL acl) {
        Object[] acEs = acl.getACEs();
        if (ArrayUtils.isNotEmpty((Object[])acEs)) {
            List groupIds = this.userManager.getGroupIds();
            for (Object ace : acEs) {
                jsonACEs.add((Object)this.convert((ACE)ace, groupIds));
            }
        }
    }

    protected JSONObject convert(ACE ace, List<String> groupIds) {
        JSONObject aceEntry = new JSONObject();
        aceEntry.element("username", (Object)ace.getUsername());
        aceEntry.element("permission", (Object)ace.getPermission());
        aceEntry.element("isGranted", ace.isGranted());
        if (CollectionUtils.isNotEmpty(groupIds)) {
            aceEntry.element("isGroup", groupIds.contains(ace.getUsername()));
        } else {
            aceEntry.element("isGroup", false);
        }
        return aceEntry;
    }
}

