/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.infos;

import fr.toutatice.ecm.platform.core.services.fetchinformation.FetchInformationsService;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.FetchExtendedDocInfos", category="Fetch", label="Fetch extended document informations", description="Fetch peculiar informations about the given document (used by Portal).")
public class FetchExtendedDocumentInfos {
    public static final String ID = "Document.FetchExtendedDocInfos";
    @Context
    protected CoreSession session;
    @Param(name="path", required=false)
    protected DocumentModel document;

    @OperationMethod
    public Blob run() throws Exception {
        JSONArray rowDocInfos = new JSONArray();
        JSONObject docInfos = new JSONObject();
        FetchInformationsService fetchInfosService = (FetchInformationsService)Framework.getService(FetchInformationsService.class);
        if (fetchInfosService != null) {
            Map infos = fetchInfosService.fetchAllExtendedInfos(this.session, this.document);
            docInfos.accumulateAll(infos);
        }
        rowDocInfos.add((Object)docInfos);
        return new StringBlob(rowDocInfos.toString(), "application/json");
    }
}

