/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.infos;

import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;

@Operation(id="Document.GetPublishedDocumentsInfos", category="Document", label="GetPublishedDocumentsInfos", description="Get informations of remote published documents of a given live document.")
public class GetPublishedDocumentsInfos {
    public static final String ID = "Document.GetPublishedDocumentsInfos";
    @Context
    protected CoreSession session;
    @Context
    protected PublisherService publisherService;
    @Param(name="readFilter", required=false)
    protected Boolean readFilter;
    public static final String WEBID_PATTERN = "webidpattern";
    public static final String WEB_APP = "/nuxeo/";

    @OperationMethod
    public StringBlob run(DocumentModel document) throws Exception {
        JSONArray informations = new JSONArray();
        GetUnrestrictedSections getter = new GetUnrestrictedSections(this.session, this.publisherService, document);
        if (BooleanUtils.isTrue((Boolean)this.readFilter)) {
            getter.run();
        } else {
            getter.runUnrestricted();
        }
        informations = getter.getInformations();
        return new StringBlob(informations.toString(), "application/json");
    }

    protected static JSONArray getSectionsInfos(PublisherService publisherService, CoreSession session, DocumentModel document, JSONArray informations) {
        Map availablePublicationTrees;
        if (!document.isProxy() && MapUtils.isNotEmpty((Map)(availablePublicationTrees = publisherService.getAvailablePublicationTrees()))) {
            for (Map.Entry treeInfo : availablePublicationTrees.entrySet()) {
                String treeName = (String)treeInfo.getKey();
                PublicationTree tree = publisherService.getPublicationTree(treeName, session, null);
                List publishedDocuments = tree.getExistingPublishedDocument((DocumentLocation)new DocumentLocationImpl(document));
                JSONObject documentInfos = new JSONObject();
                for (PublishedDocument publishedDocument : publishedDocuments) {
                    DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
                    if (!session.hasPermission(proxy.getRef(), "Read")) continue;
                    DocumentModel parentDocument = session.getParentDocument(proxy.getRef());
                    documentInfos.element("url", (Object)GetPublishedDocumentsInfos.getDocumentURL(proxy));
                    documentInfos.element("sectionTitle", (Object)parentDocument.getTitle());
                    documentInfos.element("versionLabel", (Object)proxy.getVersionLabel());
                    informations.add((Object)documentInfos);
                }
            }
        }
        return informations;
    }

    protected static String getDocumentURL(DocumentModel document) {
        String url = "";
        if (document != null && StringUtils.isNotBlank((String)(url = DocumentModelFunctions.documentUrl((DocumentModel)document)))) {
            url = WEB_APP + url;
        }
        return url;
    }

    private static class GetUnrestrictedSections
    extends UnrestrictedSessionRunner {
        private PublisherService publisherService;
        private DocumentModel document;
        private JSONArray informations;

        protected GetUnrestrictedSections(CoreSession session, PublisherService publisherService, DocumentModel document) {
            super(session);
            this.publisherService = publisherService;
            this.document = document;
            this.informations = new JSONArray();
        }

        public JSONArray getInformations() {
            return this.informations;
        }

        public void run() throws ClientException {
            this.informations = GetPublishedDocumentsInfos.getSectionsInfos(this.publisherService, this.session, this.document, this.informations);
        }
    }
}

