/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.listener.action;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.listener.action.AbstractMailAction;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class ExtractMessageInformationAction
extends AbstractMailAction {
    private static final Log log = LogFactory.getLog(ExtractMessageInformationAction.class);
    public static final String DEFAULT_BINARY_MIMETYPE = "application/octet-stream*";
    public static final String MESSAGE_RFC822_MIMETYPE = "message/rfc822";
    private String bodyContent;
    public static final String COPY_MESSAGE = "org.nuxeo.mail.imap.copy";

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean execute(ExecutionContext context) throws Exception {
        this.bodyContent = "";
        boolean copyMessage = Boolean.parseBoolean(Framework.getProperty((String)COPY_MESSAGE, (String)"false"));
        try {
            Collection<Object> ccRecipients;
            InternetAddress iAddr;
            Collection<Object> recipients;
            String subject;
            Message message;
            block25: {
                Message originalMessage = context.getMessage();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Transforming message, original subject: " + originalMessage.getSubject()));
                }
                if (originalMessage instanceof MimeMessage && copyMessage) {
                    message = new MimeMessage((MimeMessage)originalMessage);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Transforming message after full load: " + message.getSubject()));
                    }
                } else {
                    message = originalMessage;
                }
                if ((subject = message.getSubject()) != null) {
                    subject = subject.trim();
                }
                if (subject == null || "".equals(subject)) {
                    subject = "<Unknown>";
                }
                context.put("subject", subject);
                try {
                    void var8_15;
                    Address[] from = message.getFrom();
                    String sender = null;
                    Object var8_12 = null;
                    if (from != null) {
                        Address addr = from[0];
                        if (addr instanceof InternetAddress) {
                            InternetAddress iAddr2 = (InternetAddress)addr;
                            String string = iAddr2.getAddress();
                            sender = iAddr2.getPersonal() + " <" + string + ">";
                        } else {
                            String string = sender = sender + addr.toString();
                        }
                    }
                    context.put("sender", sender);
                    context.put("senderEmail", var8_15);
                }
                catch (AddressException ae) {
                    String[] values = message.getHeader("From");
                    if (values == null) break block25;
                    context.put("sender", values[0]);
                }
            }
            context.put("sendingDate", message.getSentDate());
            try {
                Address[] to = message.getRecipients(Message.RecipientType.TO);
                recipients = new ArrayList();
                if (to != null) {
                    for (Address addr : to) {
                        if (addr instanceof InternetAddress) {
                            iAddr = (InternetAddress)addr;
                            if (iAddr.getPersonal() != null) {
                                recipients.add(iAddr.getPersonal() + " <" + iAddr.getAddress() + ">");
                                continue;
                            }
                            recipients.add(iAddr.getAddress());
                            continue;
                        }
                        recipients.add(addr.toString());
                    }
                }
                context.put("recipients", recipients);
            }
            catch (AddressException ae) {
                recipients = this.getHeaderValues(message, Message.RecipientType.TO.toString());
                context.put("recipients", recipients);
            }
            try {
                Address[] toCC = message.getRecipients(Message.RecipientType.CC);
                ccRecipients = new ArrayList();
                if (toCC != null) {
                    for (Address addr : toCC) {
                        if (addr instanceof InternetAddress) {
                            iAddr = (InternetAddress)addr;
                            ccRecipients.add(iAddr.getPersonal() + " " + iAddr.getAddress());
                            continue;
                        }
                        ccRecipients.add(addr.toString());
                    }
                }
                context.put("ccRecipients", ccRecipients);
            }
            catch (AddressException ae) {
                ccRecipients = this.getHeaderValues(message, Message.RecipientType.CC.toString());
                context.put("ccRecipients", ccRecipients);
            }
            String[] messageIdHeader = message.getHeader("Message-ID");
            if (messageIdHeader != null) {
                context.put("messageId", messageIdHeader[0]);
            }
            MimetypeRegistry mimeService = (MimetypeRegistry)context.getInitialContext().get("mimetypeService");
            ArrayList arrayList = new ArrayList();
            context.put("attachments", arrayList);
            this.getAttachmentParts((Part)message, subject, mimeService, context);
            context.put("text", this.bodyContent);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    protected static String getFilename(Part p, String defaultFileName) throws Exception {
        String originalFilename = p.getFileName();
        if (originalFilename == null || originalFilename.trim().length() == 0) {
            String filename = defaultFileName;
            if (p.isMimeType("text/plain")) {
                filename = filename + ".txt";
            } else if (p.isMimeType("text/html")) {
                filename = filename + ".html";
            }
            return filename;
        }
        try {
            return MimeUtility.decodeText((String)originalFilename.trim());
        }
        catch (Exception e) {
            return originalFilename.trim();
        }
    }

    protected void getAttachmentParts(Part part, String defaultFilename, MimetypeRegistry mimeService, ExecutionContext context) throws Exception {
        String filename = ExtractMessageInformationAction.getFilename(part, defaultFilename);
        List blobs = (List)context.get("attachments");
        if (part.isMimeType("multipart/alternative")) {
            this.bodyContent = this.bodyContent + this.getText(part);
        } else {
            if (!part.isMimeType("multipart/*")) {
                String disp = part.getDisposition();
                if (disp == null && part.getContentType().toLowerCase().startsWith("text/")) {
                    this.bodyContent = this.bodyContent + ExtractMessageInformationAction.decodeMailBody(part);
                } else {
                    FileBlob fileBlob = new FileBlob(part.getInputStream());
                    String mime = DEFAULT_BINARY_MIMETYPE;
                    try {
                        if (mimeService != null) {
                            ContentType contentType = new ContentType(part.getContentType());
                            mime = mimeService.getMimetypeFromFilenameAndBlobWithDefault(filename, (Blob)fileBlob, contentType.getBaseType());
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                    fileBlob.setMimeType(mime);
                    fileBlob.setFilename(filename);
                    blobs.add(fileBlob);
                }
            }
            if (part.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)part.getContent();
                int count = mp.getCount();
                for (int i = 0; i < count; ++i) {
                    this.getAttachmentParts((Part)mp.getBodyPart(i), defaultFilename, mimeService, context);
                }
            } else if (part.isMimeType(MESSAGE_RFC822_MIMETYPE)) {
                this.getAttachmentParts((Part)part.getContent(), defaultFilename, mimeService, context);
            }
        }
    }

    private String getText(Part p) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            return ExtractMessageInformationAction.decodeMailBody(p);
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (bp.isMimeType("text/plain")) {
                    if (text != null) continue;
                    text = this.getText((Part)bp);
                    continue;
                }
                if (bp.isMimeType("text/html")) {
                    String s = this.getText((Part)bp);
                    if (s == null) continue;
                    return s;
                }
                return this.getText((Part)bp);
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                String s = this.getText((Part)mp.getBodyPart(i));
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    protected static String decodeMailBody(Part part) throws MessagingException, IOException {
        String ret;
        String encoding = null;
        if (encoding == null) {
            encoding = MimeUtility.getEncoding((DataHandler)part.getDataHandler());
        }
        InputStream is = null;
        try {
            is = MimeUtility.decode((InputStream)part.getInputStream(), (String)encoding);
        }
        catch (IOException ex) {
            log.error((Object)"Unable to read content", (Throwable)ex);
            return "";
        }
        String contType = part.getContentType();
        String charsetIdentifier = "charset=";
        String ISO88591 = "iso-8859-1";
        String WINDOWS1252 = "windows-1252";
        int offset = contType.indexOf("charset=");
        String charset = "";
        if (offset >= 0 && (offset = (charset = contType.substring(offset + "charset=".length())).indexOf(";")) > 0) {
            charset = charset.substring(0, offset);
        }
        if (!"".equals(charset)) {
            charset = charset.replaceAll("\"", "");
        }
        log.debug((Object)("Content type: " + contType + "; charset: " + charset));
        if (charset.equalsIgnoreCase("iso-8859-1")) {
            charset = "windows-1252";
            log.debug((Object)("Using replacing charset: " + charset));
        }
        byte[] streamContent = FileUtils.readBytes((InputStream)is);
        if ("".equals(charset)) {
            ret = new String(streamContent);
        } else {
            try {
                ret = new String(streamContent, charset);
            }
            catch (UnsupportedEncodingException e) {
                ret = new String(streamContent);
            }
        }
        return ret;
    }

    public Collection<String> getHeaderValues(Message message, String headerName) throws MessagingException {
        ArrayList<String> valuesList = new ArrayList<String>();
        String[] values = message.getHeader(headerName);
        if (values != null) {
            for (String value : values) {
                valuesList.add(value);
            }
        }
        return valuesList;
    }
}

