/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.acrennes.ged.dafpic.automation;

import fr.toutatice.ecm.platform.automation.helper.ToutaticeXPathPropertyHelper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.picture.api.BlobHelper;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="ImageResizeLimitQuality.Operation", category="Conversion", label="Image resizing operation", description="Operation to resize the images and lower the quality if it's above a defined threshold")
public class ResizeImageLimitQualityOperation {
    public static final String ID = "ImageResizeLimitQuality.Operation";
    public static final Log log = LogFactory.getLog(ResizeImageLimitQualityOperation.class);
    private static final float ROUND_RANGE = new Float(0.05).floatValue();
    private static final String JPEG_CONVERSATION_FORMAT = "jpg";
    @Context
    protected ImagingService service;
    @Context
    protected CoreSession session;
    protected File sourceFile;
    protected File tmpFile;
    protected File targetFile;
    @Param(name="xpath_img_in", required=true)
    protected String xpath_img_in;
    @Param(name="xpath_img_out", required=true)
    protected String xpath_img_out;
    @Param(name="img_width", required=true)
    protected int img_width;
    @Param(name="img_heidth", required=true)
    protected int img_heidth;
    @Param(name="enlarge", required=false)
    protected boolean enlarge = false;
    @Param(name="jpegMaxQuality", required=true)
    protected int jpegMaxQuality;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws PropertyException, ClientException {
        ToutaticeXPathPropertyHelper inProperty = new ToutaticeXPathPropertyHelper(doc, this.xpath_img_in);
        if (inProperty.getValue() != null) {
            if (inProperty.isList()) {
                ArrayList<Map> out = new ArrayList<Map>();
                List images = (List)inProperty.getValue();
                for (Object image : images) {
                    Object resizedImage = this.resize(image, this.img_width, this.img_heidth, this.enlarge);
                    out.add((Map)resizedImage);
                }
                doc.setPropertyValue(this.xpath_img_out, (Serializable)out);
            } else {
                Object image = inProperty.getValue();
                Object resizedImage = this.resize(image, this.img_width, this.img_heidth, this.enlarge);
                if (null != resizedImage) {
                    doc.setPropertyValue(this.xpath_img_out, (Serializable)resizedImage);
                }
            }
        }
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        for (DocumentModel doc : docs) {
            this.run(doc);
        }
        return docs;
    }

    private Object resize(Object image, int img_width, int img_heidth, boolean enlarge) throws ClientException {
        int height;
        float hscale;
        ImageInfoExtended info;
        int width;
        float wScale;
        float scale;
        String imageName = "";
        Blob imageBlob = null;
        HashMap resizedImage = image;
        if (image == null) {
            return null;
        }
        if (image instanceof Map) {
            Map imageMap = image;
            imageBlob = (Blob)imageMap.get("file");
            imageName = (String)imageMap.get("filename");
        } else if (image instanceof Blob) {
            imageBlob = (Blob)image;
        } else {
            log.debug((Object)("Param\u00e8tre d'entr\u00e9e inconsistant '" + this.xpath_img_in + "'. Doit d\u00e9signer une donn\u00e9e de type blob ou bien une donn\u00e9e complexe du type Map<String, Blob>"));
        }
        if (null != imageBlob && (this.roundToOne(scale = Math.min(wScale = (float)img_width / (float)(width = (info = this.getImageInfo(imageBlob)).getWidth()), hscale = (float)img_heidth / (float)(height = info.getHeight()))) < 1.0f || this.roundToOne(scale) > 1.0f && enlarge || info.getQuality() > this.jpegMaxQuality)) {
            imageBlob = this.call(imageBlob, JPEG_CONVERSATION_FORMAT, (int)((float)width * scale), (int)((float)height * scale), info);
            imageBlob.setMimeType("image/jpeg");
            if (image instanceof Map) {
                resizedImage = new HashMap();
                ((Map)resizedImage).put("filename", imageName);
                ((Map)resizedImage).put("file", imageBlob);
            } else {
                resizedImage = imageBlob;
            }
        }
        return resizedImage;
    }

    private float roundToOne(float nbr) {
        float rounded = nbr;
        if (1.0f - ROUND_RANGE < nbr && 1.0f + ROUND_RANGE > nbr) {
            rounded = 1.0f;
        }
        return rounded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Blob call(Blob blob, String finalFormat, int width, int height, ImageInfoExtended info) {
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
        CommandAvailability availability = cles.getCommandAvailability("resizer");
        if (!availability.isAvailable()) {
            return null;
        }
        CmdParameters params = new CmdParameters();
        String commandName = "resizer";
        try {
            this.makeFiles(blob, finalFormat, info);
            if (this.targetFile.getAbsolutePath().endsWith(JPEG_CONVERSATION_FORMAT)) {
                commandName = "jpegResizerQuality";
                String quality = info.getQuality() > this.jpegMaxQuality ? String.valueOf(this.jpegMaxQuality) : String.valueOf(info.getQuality());
                params.addNamedParameter("quality", quality);
            }
            params.addNamedParameter("targetWidth", String.valueOf(width));
            params.addNamedParameter("targetHeight", String.valueOf(height));
            params.addNamedParameter("inputFilePath", this.sourceFile.getAbsolutePath());
            params.addNamedParameter("outputFilePath", this.targetFile.getAbsolutePath());
            params.addNamedParameter("targetDepth", String.valueOf(info.getDepth()));
            ExecResult res = ResizeImageLimitQualityOperation.execCommand(commandName, params);
            if (!res.isSuccessful()) {
                throw res.getError();
            }
            FileBlob targetBlob = new FileBlob(this.targetFile);
            Framework.trackFile((File)this.targetFile, (Object)targetBlob);
            FileBlob fileBlob = targetBlob;
            return fileBlob;
        }
        catch (Exception e) {
            log.error((Object)("ImageMagick failed on command: " + commandName), (Throwable)e);
            Blob blob2 = null;
            return blob2;
        }
        finally {
            if (this.tmpFile != null) {
                this.tmpFile.delete();
            }
        }
    }

    protected void makeFiles(Blob blob, String targetExt, ImageInfoExtended info) throws Exception {
        this.sourceFile = BlobHelper.getFileFromBlob((Blob)blob);
        String ext = FilenameUtils.getExtension((String)blob.getFilename());
        if (ext == null || "".equals(ext)) {
            if (this.sourceFile == null) {
                this.sourceFile = this.createTempSource(blob, "tmp");
            }
            ext = info.getFormat();
            if (this.tmpFile == null) {
                this.sourceFile = this.createTempSource(blob, ext);
            } else {
                File newTmpFile = new File(FilenameUtils.removeExtension((String)this.tmpFile.getPath()) + "." + ext);
                this.tmpFile.renameTo(newTmpFile);
                this.tmpFile = newTmpFile;
                this.sourceFile = newTmpFile;
            }
        } else if (this.sourceFile != null && !ext.equals(FilenameUtils.getExtension((String)this.sourceFile.getName()))) {
            this.sourceFile = null;
        }
        if (this.sourceFile == null) {
            this.sourceFile = this.createTempSource(blob, ext);
        }
        if (targetExt == null) {
            targetExt = ext;
        }
        this.targetFile = File.createTempFile("nuxeoImageTarget", "." + targetExt);
    }

    protected File createTempSource(Blob blob, String ext) throws IOException {
        this.tmpFile = File.createTempFile("nuxeoImageSource", "." + ext);
        blob.transferTo(this.tmpFile);
        return this.tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfoExtended getImageInfo(Blob blob) {
        ImageInfoExtended imageInfo = null;
        File tmpFile = null;
        try {
            File file = BlobHelper.getFileFromBlob((Blob)blob);
            if (file == null) {
                tmpFile = File.createTempFile("nuxeoImageInfo", blob.getFilename() != null ? "." + FilenameUtils.getExtension((String)blob.getFilename()) : ".tmp");
                blob.transferTo(tmpFile);
                file = tmpFile;
            }
            imageInfo = this.getInfo(file.getAbsolutePath());
        }
        catch (CommandException | CommandNotAvailable e) {
            log.error((Object)("Failed to get ImageInfo for file " + blob.getFilename()), e);
        }
        catch (IOException e) {
            log.error((Object)("Failed to transfer file " + blob.getFilename()), (Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return imageInfo;
    }

    private ImageInfoExtended getInfo(String inputFilePath) throws CommandNotAvailable, CommandException {
        ExecResult result = ResizeImageLimitQualityOperation.getIdentifyResult(inputFilePath);
        if (!result.isSuccessful()) {
            log.debug((Object)("identify failed for file: " + inputFilePath));
            throw result.getError();
        }
        String out = (String)result.getOutput().get(result.getOutput().size() > 1 ? result.getOutput().size() - 1 : 0);
        String[] res = out.split(" ");
        return new ImageInfoExtended(res[1], res[2], res[0], res[3], res[4], res[5], inputFilePath);
    }

    private static ExecResult getIdentifyResult(String inputFilePath) throws CommandNotAvailable {
        CmdParameters params = new CmdParameters();
        params.addNamedParameter("inputFilePath", inputFilePath);
        return ResizeImageLimitQualityOperation.execCommand("identifyQuality", params);
    }

    private static ExecResult execCommand(String commandName, CmdParameters params) throws CommandNotAvailable {
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
        return cles.execCommand(commandName, params);
    }

    private class ImageInfoExtended
    extends ImageInfo {
        private int quality;

        public ImageInfoExtended(String width, String height, String format, String depth, String colorSpace, String quality, String filePath) {
            super(width, height, format, depth, colorSpace, filePath);
            this.quality = Integer.parseInt(quality);
        }

        public int getQuality() {
            return this.quality;
        }
    }
}

