/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.acrennes.ged.dafpic.freemarker;

import fr.gouv.education.acrennes.ged.dafpic.freemarker.AcarenDafpicGrefTable;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDirectoryMngtHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.nuxeo.ecm.automation.features.PlatformFunctions;

public class AcarenDafpicFunctions
extends PlatformFunctions {
    private static final Log log = LogFactory.getLog(AcarenDafpicFunctions.class);
    private Connection conn;
    private Statement stmt;
    private Map<String, String> inseeCodes;
    private Map<String, String> gretaCodes;
    private Map<String, String> agenceCodes;
    private static final String DEFAULT_CODE_INSEE = "";
    private static final String DEFAULT_CODE_GRETA = "";
    private static final String DEFAULT_CODE_AGENCE = "";
    private static final String DEFAULT_CODE_PUBLIC = "";
    private static final String DEFAULT_CODE_FUNCTION = "000";

    public AcarenDafpicFunctions() throws ClassNotFoundException, SQLException {
        Class.forName("org.relique.jdbc.csv.CsvDriver");
        this.conn = DriverManager.getConnection("jdbc:relique:csv:class:" + AcarenDafpicGrefTable.class.getName());
        this.stmt = this.conn.createStatement();
        this.inseeCodes = new HashMap<String, String>();
        this.gretaCodes = new HashMap<String, String>();
        this.agenceCodes = new HashMap<String, String>();
    }

    public String getVocabularyLabelList(String voc, String key) throws Exception {
        String label = "";
        if (StringUtils.isNotBlank((String)key)) {
            ToutaticeDirectoryMngtHelper.instance().getDirectoryEntriesLocalizedLabel(voc.split(";"), key, Locale.FRANCE);
        }
        return label;
    }

    public String getVocabularyLabelItem(String voc, String key, int index) throws Exception {
        List list;
        String label = "";
        if (StringUtils.isNotBlank((String)key) && (list = ToutaticeDirectoryMngtHelper.instance().getDirectoryEntriesLocalizedLabelList(voc.split(";"), key, Locale.FRANCE)).size() >= index) {
            label = (String)list.get(index - 1);
        }
        return label;
    }

    public String getInseeCode(String ZIP_code) throws Exception {
        String code = "";
        if (StringUtils.isNotBlank((String)ZIP_code)) {
            if (null == this.inseeCodes.get(ZIP_code)) {
                ResultSet results = this.stmt.executeQuery("SELECT CODE_POSTAL, CODE_INSEE, LIBELLE_INSEE FROM catalogue_CODES_INSEE WHERE CODE_POSTAL = '" + ZIP_code + "'");
                if (results.next()) {
                    code = results.getString("CODE_INSEE");
                    this.inseeCodes.put(ZIP_code, code);
                }
                results.close();
            } else {
                code = this.inseeCodes.get(ZIP_code);
            }
        }
        if ("".equals(ZIP_code)) {
            log.warn((Object)("Code INSEE non trouv\u00e9 pour le code postal '" + (null != ZIP_code ? ZIP_code : "") + "'"));
        }
        return code;
    }

    public String getCodeGreta(String title) throws Exception {
        String code = "";
        if (StringUtils.isNotBlank((String)title)) {
            if (null == this.gretaCodes.get(title)) {
                String sigle = this.noAccentCapitalized(title).replace("'", "%");
                ResultSet results = this.stmt.executeQuery("SELECT REFERENCE FROM catalogue_CODES_ORGANISMES WHERE SIGLE LIKE '" + sigle + "'");
                if (results.next()) {
                    code = results.getString("REFERENCE");
                    this.gretaCodes.put(title, code);
                }
                results.close();
            } else {
                code = this.gretaCodes.get(title);
            }
        }
        if ("".equals(code)) {
            log.warn((Object)("Code GRETA non trouv\u00e9 pour le GRETA '" + (null != title ? title : "") + "'"));
        }
        return code;
    }

    public String getCodeAgence(String title) throws Exception {
        String code = "";
        if (StringUtils.isNotBlank((String)title)) {
            if (null == this.agenceCodes.get(title)) {
                String sigle = this.noAccentCapitalized(title);
                sigle = sigle.replace("AGENCE DE", "").trim();
                sigle = sigle.split(" - ")[0];
                ResultSet results = this.stmt.executeQuery("SELECT REFERENCE FROM catalogue_CODES_ORGANISMES WHERE SIGLE LIKE '%" + sigle + "%'");
                if (results.next()) {
                    code = results.getString("REFERENCE");
                    this.agenceCodes.put(title, code);
                }
                results.close();
            } else {
                code = this.agenceCodes.get(title);
            }
        }
        if ("".equals(code)) {
            log.warn((Object)("Code agence non trouv\u00e9 pour l'agence '" + (null != title ? title : "") + "'"));
        }
        return code;
    }

    public String getCodePublic(String publicCode) throws Exception {
        String code = "";
        if (StringUtils.isNotBlank((String)publicCode)) {
            code = publicCode;
            if ("40".equals(publicCode)) {
                code = "42";
            }
        }
        return code;
    }

    public String getContactFunctionCode(String function) throws Exception {
        return DEFAULT_CODE_FUNCTION;
    }

    public String logger(String level, String message) throws Exception {
        if (level.equals(Level.INFO.getName())) {
            log.info((Object)message);
        } else if (level.equals(Level.WARNING.getName())) {
            log.warn((Object)message);
        } else if (level.equals(Level.SEVERE.getName())) {
            log.error((Object)message);
        }
        return "ok";
    }

    public void uninstall() {
        try {
            if (null != this.stmt) {
                this.stmt.close();
            }
            if (null != this.conn) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)("Failed to uninstall the DAFPIC automation/freemarker functions, error: " + e.getMessage()));
        }
    }

    public String escapeXML(String xml) {
        return StringEscapeUtils.escapeXml((String)xml);
    }

    public String extractTextFromHTML(String html) {
        return Jsoup.parse((String)html).text();
    }

    private String noAccentCapitalized(String raw) {
        String temp = raw.toUpperCase();
        temp = temp.replaceAll("\u00c0|\u00c1|\u00c2|\u00c3|\u00c4|\u00c5|\u00c6", "A");
        temp = temp.replaceAll("\u00c8|\u00c9|\u00ca|\u00cb", "E");
        temp = temp.replaceAll("\u00cc|\u00cd|\u00ce|\u00cf", "I");
        temp = temp.replaceAll("\u00d2|\u00d3|\u00d4|\u00d5|\u00d6", "O");
        temp = temp.replaceAll("\u00d9|\u00da|\u00db|\u00dc", "U");
        temp = temp.replace('\u00dd', 'Y');
        temp = temp.replace('\u00c7', 'C');
        return temp;
    }
}

