/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.acrennes.ged.dafpic.freemarker;

import fr.gouv.education.acrennes.ged.dafpic.freemarker.DafpicResourceLocatorHelper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.relique.io.TableReader;

public class AcarenDafpicGrefTable
implements TableReader {
    private static final Log log = LogFactory.getLog(AcarenDafpicGrefTable.class);
    private static final String[] TABLES_NAMES = new String[]{"catalogue_CODES_INSEE", "catalogue_CODES_PUBLICS", "catalogue_CODES_FONCTIONS", "catalogue_CODES_ORGANISMES"};
    Map<String, URL> urlMap = new HashMap<String, URL>();

    public Reader getReader(Statement statement, String tableName) throws SQLException {
        InputStreamReader reader = null;
        URL url = null;
        try {
            if (!this.urlMap.containsKey(tableName)) {
                url = DafpicResourceLocatorHelper.instance().getResourceURL(tableName);
                this.urlMap.put(tableName, url);
            } else {
                url = this.urlMap.get(tableName);
            }
            if (null != url) {
                reader = new InputStreamReader(url.openStream());
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to obtain a reader on the GREF table '" + tableName + "', error: " + e.getMessage()));
        }
        return reader;
    }

    public List getTableNames(Connection connection) throws SQLException {
        return Arrays.asList(TABLES_NAMES);
    }
}

