/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.acrennes.ged.dafpic.web;

import fr.gouv.education.acrennes.ged.dafpic.constants.GlobalConstants;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDirectoryMngtHelper;
import fr.toutatice.es.dafpic.model.CompositeDocumentModelImpl;
import fr.toutatice.es.dafpic.query.helper.DenormalizedQueryHelper;
import fr.toutatice.es.dafpic.query.helper.EsQueryHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.ui.web.invalidations.AutomaticDocumentBasedInvalidation;
import org.nuxeo.ecm.platform.ui.web.invalidations.DocumentContextBoundActionBean;

@Name(value="stageDocumentRender")
@Scope(value=ScopeType.CONVERSATION)
@AutomaticDocumentBasedInvalidation
public class StageDocumentRenderBean
extends DocumentContextBoundActionBean
implements Serializable {
    private static final long serialVersionUID = 12432825228832921L;
    private static final Log log = LogFactory.getLog(StageDocumentRenderBean.class);
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    private String currentMode = null;
    private DocumentModel linkedTrainingDocument = null;
    private String linkedTrainingDocumentRef = null;
    private String linkedContactsDocumentRef = null;
    private boolean doReloadDocTrainingData = true;
    private boolean doReloadDocContactData = true;
    private Map<String, String> localization = null;
    protected String searchKeywords;
    private String searchFieldFirstName;
    private String searchFieldLastName;
    protected String[] searchDomainKeywords;
    protected String parentAgencyId;
    protected boolean hasSearchTrainingResults = false;
    protected boolean hasSearchContactResults = false;
    protected List<DocumentModel> resultTrainingDocuments;
    protected List<DocumentModel> resultContactDocuments;

    public String getLinkedTrainingDocumentRef() {
        return this.linkedTrainingDocumentRef;
    }

    public void setLinkedTrainingDocumentRef(String linkedTrainingDocumentRef) {
        this.linkedTrainingDocumentRef = linkedTrainingDocumentRef;
    }

    public String getLinkedContactsDocumentRef() {
        return this.linkedContactsDocumentRef;
    }

    public void setLinkedContactsDocumentRef(String linkedContactsDocumentRef) {
        this.linkedContactsDocumentRef = linkedContactsDocumentRef;
    }

    public String getParentAgencyId() throws ClientException {
        String id = this.parentAgencyId;
        if (StringUtils.isBlank((String)id)) {
            DocumentRef currentAgencyRef;
            DocumentModel currentDoc = this.getCurrentDocument();
            if ("Stage".equals(currentDoc.getType())) {
                DocumentRef stageFolderRef = currentDoc.getParentRef();
                currentAgencyRef = this.documentManager.getDocument(stageFolderRef).getParentRef();
            } else {
                currentAgencyRef = currentDoc.getParentRef();
            }
            DocumentModel currentAgency = this.documentManager.getDocument(currentAgencyRef);
            id = currentAgency.getPathAsString();
        }
        return id;
    }

    public void setParentAgencyId(String parentAgencyId) {
        this.parentAgencyId = parentAgencyId;
    }

    public List<DocumentModel> getResultTrainingDocuments() {
        return this.resultTrainingDocuments;
    }

    public void setResultTrainingDocuments(List<DocumentModel> resultTrainingDocuments) {
        this.resultTrainingDocuments = resultTrainingDocuments;
    }

    public List<DocumentModel> getResultContactDocuments() {
        return this.resultContactDocuments;
    }

    public void setResultContactDocuments(List<DocumentModel> resultContactDocuments) {
        this.resultContactDocuments = resultContactDocuments;
    }

    public String[] getSearchDomainKeywords() {
        return this.searchDomainKeywords != null ? this.searchDomainKeywords : GlobalConstants.CST_DEFAULT_EMPTY_DIRECTORY;
    }

    public void setSearchDomainKeywords(String[] searchDomainKeywords) {
        this.searchDomainKeywords = null != searchDomainKeywords && 0 != searchDomainKeywords.length ? searchDomainKeywords : GlobalConstants.CST_DEFAULT_EMPTY_DIRECTORY;
    }

    public void setHasSearchTrainingResults(boolean hasSearchTrainingResults) {
        this.hasSearchTrainingResults = hasSearchTrainingResults;
    }

    public void setHasSearchContactResults(boolean hasSearchContactResults) {
        this.hasSearchContactResults = hasSearchContactResults;
    }

    public String getSearchKeywords() {
        return this.searchKeywords;
    }

    public void setSearchKeywords(String searchKeywords) {
        this.searchKeywords = searchKeywords;
    }

    public String getSearchFieldFirstName() {
        return this.searchFieldFirstName;
    }

    public void setSearchFieldFirstName(String searchFieldFirstName) {
        this.searchFieldFirstName = searchFieldFirstName;
    }

    public String getSearchFieldLastName() {
        return this.searchFieldLastName;
    }

    public void setSearchFieldLastName(String searchFieldLastName) {
        this.searchFieldLastName = searchFieldLastName;
    }

    public void setObjectDocumentContactUidInput(String value) {
    }

    public List<DocumentModel> getSearchDocumentTrainingResults() {
        return this.resultTrainingDocuments;
    }

    public List<DocumentModel> getSearchDocumentContactResults() {
        return this.resultContactDocuments;
    }

    public boolean getHasSearchTrainingResults() {
        return this.hasSearchTrainingResults;
    }

    public boolean getHasSearchContactResults() {
        return this.hasSearchContactResults;
    }

    public List<SelectItem> getAgenciesList() {
        LinkedList<SelectItem> selectItemList;
        block3: {
            selectItemList = new LinkedList<SelectItem>();
            SelectItem emptyItem = new SelectItem();
            emptyItem.setValue((Object)"");
            emptyItem.setLabel("");
            selectItemList.add(emptyItem);
            try {
                StringBuffer query = new StringBuffer(4);
                query.append("select * from ");
                query.append("Agence");
                query.append(" where ");
                query.append(" ecm:mixinType != 'HiddenInNavigation'  AND ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0");
                DocumentModelList agencyList = EsQueryHelper.query((CoreSession)this.documentManager, (String)query.toString(), (int)50);
                for (DocumentModel agency : agencyList) {
                    SelectItem item = new SelectItem();
                    item.setValue((Object)agency.getPathAsString());
                    item.setLabel(agency.getTitle());
                    selectItemList.add(item);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Failed to list the agencies from the VCS, error: " + e.getMessage()));
            }
        }
        return selectItemList;
    }

    public DocumentModelList getOtherAgenciesList() throws ClientException {
        DocumentModelListImpl otherAgencies = new DocumentModelListImpl();
        DocumentModel currentDoc = this.getCurrentDocument();
        if ("Stage".equals(currentDoc.getType())) {
            String formationRef = (String)((Object)currentDoc.getPropertyValue("stage:refFormation"));
            String query = String.format("select * from Stage where ecm:uuid <> '%s' and stage:formation.ttc:webid = '%s'", currentDoc.getId(), formationRef);
            DocumentModelList esResults = DenormalizedQueryHelper.query((CoreSession)this.documentManager, (String)query);
            for (CompositeDocumentModelImpl stage : esResults) {
                otherAgencies.add((Object)stage.getLinkedDocument("stage:agence"));
            }
        }
        return otherAgencies;
    }

    public DocumentModelList getContactsList(String mode) throws ClientException {
        DocumentModelList list = null;
        DocumentModel currentDoc = this.getCurrentDocument();
        String refs = this.getAssoiciatedContactsRef(mode, currentDoc);
        if (StringUtils.isNotBlank((String)refs)) {
            list = this.getReferencedDocumentsFromDocRefs("ContactAgence", refs);
        }
        return list;
    }

    public DocumentModel getTraining(String mode) throws ClientException {
        DocumentModelList list;
        DocumentModel doc = null;
        DocumentModel currentDoc = this.getCurrentDocument();
        String refs = this.getAssoiciatedTrainingRef(mode, currentDoc);
        if (StringUtils.isNotBlank((String)refs) && !(list = this.getReferencedDocumentsFromDocRefs("Formation", refs)).isEmpty()) {
            doc = (DocumentModel)list.get(0);
        }
        return doc;
    }

    private DocumentModelList getReferencedDocumentsFromDocRefs(String type, String docRefs) throws ClientException {
        DocumentModelListImpl docList;
        block6: {
            docList = new DocumentModelListImpl();
            try {
                String[] docRefList;
                for (String docRef : docRefList = docRefs.split(";")) {
                    if (!StringUtils.isNotBlank((String)docRef)) continue;
                    try {
                        DocumentModel result = this.documentManager.getDocument((DocumentRef)new IdRef(docRef));
                        docList.add((Object)result);
                    }
                    catch (Exception e) {
                        String query = "select * from %s where ttc:webid = '%s' AND ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
                        query = String.format(query, type, docRef);
                        DocumentModelList references = this.documentManager.query(query);
                        if (CollectionUtils.isNotEmpty((Collection)references) && references.size() == 1) {
                            docList.add(references.get(0));
                            continue;
                        }
                        if (!"Formation".equals(type)) continue;
                        log.error((Object)("No or more than one " + type + " with key " + docRef));
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)("Failed to retrieve the document list, error: " + e.getMessage()));
            }
        }
        return docList;
    }

    public void listenerAddContact(ActionEvent event) {
        String newContactsRefs;
        UIComponent component = event.getComponent();
        UIComponent contactInput = component.findComponent(":document_create:nxl_LayoutStage:objectDocumentContactFieldInput");
        if (contactInput == null) {
            contactInput = component.findComponent(":document_edit:nxl_LayoutStage:objectDocumentContactFieldInput");
        }
        if (contactInput != null && StringUtils.isNotBlank((String)(newContactsRefs = (String)((UIInput)contactInput).getSubmittedValue()))) {
            String newContactRef = StringUtils.substringAfterLast((String)newContactsRefs, (String)";");
            this.addContact(newContactRef);
        }
    }

    public void listenerAddTraining(ActionEvent event) {
        UIComponent component = event.getComponent();
        UIComponent trainingInput = component.findComponent(":document_create:nxl_LayoutStage:objectDocumentTrainingFieldInput");
        if (trainingInput == null) {
            trainingInput = component.findComponent(":document_edit:nxl_LayoutStage:objectDocumentTrainingFieldInput");
        }
        if (trainingInput != null) {
            String newContactRef = (String)((UIInput)trainingInput).getSubmittedValue();
            this.addTraining(newContactRef);
        }
    }

    public void addContact(String newRef) {
        this.linkedContactsDocumentRef = this.addContactElt(this.linkedContactsDocumentRef, newRef);
    }

    private String addContactElt(String contacts, String item) {
        String result = contacts;
        if (StringUtils.isNotBlank((String)contacts)) {
            if (!contacts.matches(".*" + item + ".*")) {
                result = contacts + ";" + item;
            }
        } else {
            result = item;
        }
        return result;
    }

    public void deleteContact(DocumentModel doc) {
        if (StringUtils.isNotBlank((String)this.linkedContactsDocumentRef)) {
            if (StringUtils.contains((String)this.linkedContactsDocumentRef, (String)doc.getId())) {
                this.linkedContactsDocumentRef = this.removeContactElt(this.linkedContactsDocumentRef, doc.getId());
            } else {
                String ref = (String)((Object)doc.getPropertyValue("ttc:webid"));
                if (StringUtils.contains((String)this.linkedContactsDocumentRef, (String)ref)) {
                    this.linkedContactsDocumentRef = this.removeContactElt(this.linkedContactsDocumentRef, ref);
                }
            }
        }
    }

    private String removeContactElt(String contacts, String item) {
        String result = contacts.replaceAll(item, "");
        result = result.replaceAll(";;", ";");
        result = result.replaceAll("^;", "").replaceAll(";$", "");
        return result;
    }

    public void addTraining(String newRef) {
        this.linkedTrainingDocumentRef = newRef;
    }

    public void deleteTraining() {
        this.linkedTrainingDocument = null;
        this.linkedTrainingDocumentRef = "";
    }

    public Map<String, String> getLocalisationData() throws ClientException {
        block3: {
            DocumentModel currentDoc = null;
            if (null == this.localization) {
                this.localization = new HashMap<String, String>();
                try {
                    currentDoc = this.getCurrentDocument();
                    DocumentRef stageFolderRef = currentDoc.getParentRef();
                    DocumentRef agencyRef = this.documentManager.getDocument(stageFolderRef).getParentRef();
                    DocumentModel agency = this.documentManager.getDocument(agencyRef);
                    this.localization.put("agency_title", agency.getTitle());
                    this.localization.put("agency_address", (String)((Object)agency.getPropertyValue("structure:postalAddress")));
                    this.localization.put("agency_ZIPnCity", (String)((Object)agency.getPropertyValue("structure:postalCode")) + " " + (String)((Object)agency.getPropertyValue("structure:locality")));
                    this.localization.put("agency_tel", (String)((Object)agency.getPropertyValue("structure:telephoneNumber")));
                    this.localization.put("agency_fax", (String)((Object)agency.getPropertyValue("structure:fax")));
                    this.localization.put("agency_email", (String)((Object)agency.getPropertyValue("structure:mail")));
                    DocumentRef gretaRef = agency.getParentRef();
                    DocumentModel greta = this.documentManager.getDocument(gretaRef);
                    this.localization.put("greta_title", greta.getTitle());
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Failed to retrieve the localization data from the current stage document '" + (null != currentDoc ? currentDoc.getTitle() : "") + "', error: " + e.getMessage()));
                }
            }
        }
        return this.localization;
    }

    public Date getTrainingDateField(String mode, String xPath) {
        Date field = null;
        Object dateField = this.getTrainingField(this.currentMode, xPath);
        if (null != dateField) {
            if (dateField instanceof GregorianCalendar) {
                field = ((GregorianCalendar)dateField).getTime();
            } else if (dateField instanceof Date) {
                field = (Date)dateField;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("The meta-data with path '" + xPath + "' si supposed to be either of type 'Date' or 'GregorianCalendar' but is not (type: '" + dateField.getClass() + "')."));
            }
        }
        return field;
    }

    public Object getTrainingField(String mode, String xPath) {
        Object field = null;
        DocumentModel trainingDoc = this.getAssociatedTraining(this.currentMode);
        if (null != trainingDoc) {
            field = this.getDocumentProperty(trainingDoc, xPath);
        }
        return field;
    }

    public String getDocumentDirectoryField(String fieldValue, String directories, int index) {
        String label = "";
        try {
            String[] directoriesList = directories.split(",");
            if (StringUtils.isNotBlank((String)fieldValue)) {
                if (0 > index) {
                    label = ToutaticeDirectoryMngtHelper.instance().getDirectoryEntriesLocalizedLabel(directoriesList, fieldValue, Locale.FRENCH);
                } else {
                    List fieldLabels = ToutaticeDirectoryMngtHelper.instance().getDirectoryEntriesLocalizedLabelList(directoriesList, fieldValue, Locale.FRENCH);
                    if (index <= fieldLabels.size()) {
                        label = (String)fieldLabels.get(index);
                    } else {
                        log.debug((Object)("Failed to get the label of the metadata '" + fieldValue + "', error: the index requested (" + index + ") is greater than the label list size ('" + fieldLabels.size() + "'"));
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to get the label of the metadata '" + fieldValue + "', error: " + e.getMessage()));
        }
        return label;
    }

    public String getTrainingDirectoryFieldFromRef(String trainingReference, String directories, String fieldName, int index) {
        String label = "";
        String query = String.format("select * from Formation where ttc:webid = \"%s\"", trainingReference);
        DocumentModelList trainings = EsQueryHelper.query((CoreSession)this.documentManager, (String)query);
        if (CollectionUtils.isNotEmpty((Collection)trainings) && trainings.size() == 1) {
            DocumentModel trainingDocument = (DocumentModel)trainings.get(0);
            String fieldValue = (String)this.getDocumentProperty(trainingDocument, fieldName);
            label = this.getDocumentDirectoryField(fieldValue, directories, index);
        } else {
            log.debug((Object)("Failed to get the value of the metadata '" + fieldName + "' of the training ref '" + trainingReference));
        }
        return label;
    }

    public String getTitle(DocumentModel doc) {
        return (String)this.getDocumentProperty(doc, "dc:title");
    }

    public String getRef(DocumentModel doc) {
        return doc != null ? doc.getId() : "";
    }

    public String getFunction(DocumentModel doc) {
        return (String)this.getDocumentProperty(doc, "contact:fonction");
    }

    public String searchContacts() throws ClientException {
        ArrayList<String> constraints = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.searchFieldFirstName)) {
            this.searchFieldFirstName = this.searchFieldFirstName.trim();
            if (!this.searchFieldFirstName.equals("*")) {
                constraints.add(String.format("contactagence:firstName ILIKE '%%%s%%'", this.searchFieldFirstName.replaceAll("'", "\\\\'")));
            }
        }
        if (StringUtils.isNotBlank((String)this.searchFieldLastName)) {
            this.searchFieldLastName = this.searchFieldLastName.trim();
            if (!this.searchFieldLastName.equals("*")) {
                constraints.add(String.format("contactagence:lastName ILIKE '%%%s%%'", this.searchFieldLastName.replaceAll("'", "\\\\'")));
            }
        }
        if (StringUtils.isNotBlank((String)this.parentAgencyId)) {
            constraints.add("ecm:path startswith '" + this.parentAgencyId + "'");
        }
        this.searchDocuments("ContactAgence", constraints, "ORDER BY contactagence:lastName ASC");
        return "create_contact_relation_search_document_popup";
    }

    public String searchTraining() throws ClientException {
        String domains;
        String domainsSearchPattern = null;
        ArrayList<String> constraints = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.searchKeywords)) {
            this.searchKeywords = this.searchKeywords.trim();
            if (!this.searchKeywords.equals("*")) {
                constraints.add(String.format("ecm:fulltext = '%s'", this.searchKeywords.replaceAll("'", "\\\\'")));
            }
        }
        if (null != this.searchDomainKeywords && 0 < this.searchDomainKeywords.length && StringUtils.isNotBlank((String)(domains = this.searchDomainKeywords[0]))) {
            domainsSearchPattern = domains.replaceAll("/", "").trim();
            constraints.add(String.format("formation:uid LIKE '%s%%'", domainsSearchPattern));
        }
        this.searchDocuments("Formation", constraints, "ORDER BY dc:title ASC");
        return "create_training_relation_search_document_popup";
    }

    private void searchDocuments(String docType, List<String> constraints, String orderBy) throws ClientException {
        block6: {
            DocumentModelList resultDocuments = null;
            try {
                StringBuffer query = new StringBuffer(5);
                query.append(String.format("SELECT * FROM " + docType + " WHERE %s", StringUtils.join((Object[])constraints.toArray(), (String)" AND ")));
                if (CollectionUtils.isNotEmpty(constraints)) {
                    query.append(" and ");
                }
                query.append(" ecm:mixinType != 'HiddenInNavigation'  AND ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0");
                if (StringUtils.isNotBlank((String)orderBy)) {
                    query.append(" ");
                    query.append(orderBy);
                }
                resultDocuments = EsQueryHelper.query((CoreSession)this.documentManager, (String)query.toString(), (int)50);
                if ("Formation".equals(docType)) {
                    this.resultTrainingDocuments = resultDocuments;
                    this.hasSearchTrainingResults = !resultDocuments.isEmpty();
                } else {
                    this.resultContactDocuments = resultDocuments;
                    this.hasSearchContactResults = !resultDocuments.isEmpty();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)("Fail to search for documents of type '" + docType + "', error: " + e.getMessage()));
            }
        }
    }

    private DocumentModel getAssociatedTraining(String mode) {
        block4: {
            if (null == this.linkedTrainingDocument) {
                DocumentModel currentDoc = this.getCurrentDocument();
                try {
                    DocumentModelList list;
                    String ref = this.getAssoiciatedTrainingRef(mode, currentDoc);
                    if (StringUtils.isNotBlank((String)ref) && !(list = this.getReferencedDocumentsFromDocRefs("Formation", ref)).isEmpty() && list.size() == 1) {
                        this.linkedTrainingDocument = (DocumentModel)list.get(0);
                    }
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("Failed to get the training document associated to the stage '" + currentDoc.getName() + "', error: " + e.getMessage()));
                }
            }
        }
        return this.linkedTrainingDocument;
    }

    private String getAssoiciatedTrainingRef(String mode, DocumentModel doc) {
        this.onModeChange(mode);
        if (this.doReloadDocTrainingData) {
            this.doReloadDocTrainingData = false;
            if (doc.getType().equals("Stage")) {
                this.linkedTrainingDocumentRef = (String)this.getDocumentProperty(doc, "stage:refFormation");
            }
        }
        return this.linkedTrainingDocumentRef;
    }

    private String getAssoiciatedContactsRef(String mode, DocumentModel doc) {
        this.onModeChange(mode);
        if (this.doReloadDocContactData) {
            this.doReloadDocContactData = false;
            if (doc.getType().equals("Stage")) {
                this.linkedContactsDocumentRef = (String)this.getDocumentProperty(doc, "stage:refContacts");
            }
        }
        return this.linkedContactsDocumentRef;
    }

    private void onModeChange(String mode) {
        block6: {
            if (!mode.equals(this.currentMode) || "view".equalsIgnoreCase(mode)) {
                this.resetBeanCache(null);
                this.currentMode = mode;
                DocumentModel currentDoc = this.getCurrentDocument();
                if (null != currentDoc) {
                    try {
                        currentDoc.refresh(141, new String[]{"stage", "dc"});
                    }
                    catch (ClientException e) {
                        if (!log.isDebugEnabled()) break block6;
                        try {
                            log.debug((Object)("Failed to refresh the current document model '" + currentDoc.getTitle() + "', error: " + e.getMessage()));
                        }
                        catch (ClientException clientException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    @Observer(value={"changeableDocumentCreated"}, create=false)
    public void onDocumentCreation() {
        this.resetBeanCache(null);
        DocumentModel currentDoc = this.getCurrentDocument();
        if (null != currentDoc) {
            try {
                currentDoc.setPropertyValue("stage:lifeCycle", (Serializable)((Object)"HorsLigne"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void resetBeanCache(DocumentModel newCurrentDocumentModel) {
        this.linkedTrainingDocumentRef = null;
        this.linkedContactsDocumentRef = null;
        this.linkedTrainingDocument = null;
        this.doReloadDocTrainingData = true;
        this.doReloadDocContactData = true;
        this.localization = null;
        this.currentMode = null;
        this.parentAgencyId = null;
    }

    private Object getDocumentProperty(DocumentModel doc, String xPath) {
        Serializable field;
        block2: {
            field = null;
            try {
                field = doc.getPropertyValue(xPath);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Failed to get the property '" + xPath + "' from the document '" + doc.getName() + "' (path: '" + doc.getPathAsString() + "'), error: " + e.getMessage()));
            }
        }
        return field;
    }
}

