/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.es.dafpic.listener;

import fr.toutatice.es.dafpic.constants.Constants;
import javax.transaction.Synchronization;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.elasticsearch.listener.ElasticSearchInlineListener;

public class DafpicElasticSearchInlineListener
extends ElasticSearchInlineListener {
    public void handleEvent(Event event) throws ClientException {
        String eventId = event.getName();
        if (!((Boolean)isEnlisted.get()).booleanValue()) {
            if (event.isCommitEvent()) {
                this.afterCompletion(3);
                return;
            }
            isEnlisted.set(this.registerSynchronization((Synchronization)this));
        }
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        this.stackCommand(docCtx, eventId);
        DocumentModel sourceDocument = docCtx.getSourceDocument();
        if (sourceDocument != null && this.needToReindex(sourceDocument)) {
            CoreSession coreSession = docCtx.getCoreSession();
            this.stackCommands(coreSession, sourceDocument, eventId);
        }
    }

    protected boolean needToReindex(DocumentModel sourceDocument) {
        return Constants.TYPES.contains(sourceDocument.getType());
    }

    protected void stackCommands(CoreSession coreSession, DocumentModel doc, String eventId) {
        StringBuilder queryBuilder = new StringBuilder().append("select * from Stage where ");
        String docType = doc.getType();
        String webId = (String)((Object)doc.getPropertyValue("ttc:webid"));
        String id = doc.getId();
        switch (docType) {
            case "Formation": {
                queryBuilder.append("stage:refFormation = \"").append(webId).append("\"");
                break;
            }
            case "ContactAgence": {
                queryBuilder.append("stage:refContacts ilike \"%").append(webId).append(";%\"");
                break;
            }
            case "Agence": 
            case "Greta": {
                queryBuilder.append("ecm:ancestorId = \"").append(id).append("\"");
            }
        }
        queryBuilder.append(" and ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0 AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'");
        DocumentModelList documentModelList = coreSession.query(queryBuilder.toString());
        for (DocumentModel denormalizedDoc : documentModelList) {
            this.stackCommand(denormalizedDoc, eventId, Boolean.TRUE);
        }
    }
}

