/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.es.dafpic.query.helper;

import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class EsQueryHelper {
    private static int NO_RESULTS_LIMIT = -1;
    private static ElasticSearchService ess;

    private EsQueryHelper() {
    }

    public static ElasticSearchService getElasticSearchService() {
        if (ess == null) {
            ess = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
        }
        return ess;
    }

    public static DocumentModelList query(CoreSession session, String nxqlQuery) {
        return EsQueryHelper.query(session, nxqlQuery, NO_RESULTS_LIMIT);
    }

    public static DocumentModelList query(CoreSession session, String nxqlQuery, int limit) {
        NxQueryBuilder nxQuery = new NxQueryBuilder(session).nxql(nxqlQuery).limit(limit);
        return EsQueryHelper.getElasticSearchService().query(nxQuery);
    }

    public static DocumentModelList paginatedQuery(CoreSession session, String nxqlQuery, int offset, int limit) {
        NxQueryBuilder nxQuery = new NxQueryBuilder(session).nxql(nxqlQuery).offset(offset).limit(limit);
        return EsQueryHelper.getElasticSearchService().query(nxQuery);
    }

    public static IterableQueryResult queryAndFetch(CoreSession session, String nxqlQuery, int limit) {
        NxQueryBuilder nxQuery = new NxQueryBuilder(session).nxql(nxqlQuery).limit(limit);
        nxQuery.fetchFromDatabase();
        EsResult esResults = EsQueryHelper.getElasticSearchService().queryAndAggregate(nxQuery);
        return esResults.getRows();
    }
}

