/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.el;

import java.beans.FeatureDescriptor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.el.CompositeComponentExpressionHolder;
import org.richfaces.el.ValueDescriptor;
import org.richfaces.el.ValueReference;
import org.richfaces.validator.GraphValidatorState;

public class CapturingELContext
extends ELContext {
    private final ELContext parent;
    private ValueReference reference = null;
    private final InterceptingResolver resolver;

    public CapturingELContext(ELContext parent, Map<Object, GraphValidatorState> states) {
        this.parent = parent;
        this.resolver = new InterceptingResolver(parent.getELResolver(), states);
    }

    public ValueReference getReference() {
        return this.reference;
    }

    private boolean isContainerObject(Object base) {
        return base instanceof Collection || base instanceof Map || base.getClass().isArray();
    }

    public boolean hasReferenceExpression() {
        return this.reference != null && this.reference.getBase() instanceof CompositeComponentExpressionHolder;
    }

    public ValueExpression getReferenceExpression() {
        CompositeComponentExpressionHolder expressionHolder = (CompositeComponentExpressionHolder)this.reference.getBase();
        return expressionHolder.getExpression(this.reference.getProperty().toString());
    }

    public ValueDescriptor getDescriptor() {
        Object base;
        ValueReference localReference = this.reference;
        while (true) {
            if (localReference == null || localReference.getBase() == null || localReference.getProperty() == null) {
                return null;
            }
            base = localReference.getBase();
            if (!this.isContainerObject(base) || !localReference.hasNext()) break;
            localReference = localReference.next();
        }
        return new ValueDescriptor(base.getClass(), localReference.getProperty().toString());
    }

    public ELResolver getELResolver() {
        return this.resolver;
    }

    public Object getContext(Class key) {
        return this.parent.getContext(key);
    }

    public FunctionMapper getFunctionMapper() {
        return this.parent.getFunctionMapper();
    }

    public Locale getLocale() {
        return this.parent.getLocale();
    }

    public VariableMapper getVariableMapper() {
        return this.parent.getVariableMapper();
    }

    public void putContext(Class key, Object contextObject) {
        this.parent.putContext(key, contextObject);
    }

    public void setLocale(Locale locale) {
        this.parent.setLocale(locale);
    }

    private final class InterceptingResolver
    extends ELResolver {
        private final ELResolver delegate;
        private boolean clonedObject;
        private final Map<Object, GraphValidatorState> states;

        public InterceptingResolver(ELResolver delegate, Map<Object, GraphValidatorState> states) {
            this.delegate = delegate;
            this.states = states;
        }

        public void setValue(ELContext context, Object base, Object property, Object value) {
            if (base != null) {
                if (this.clonedObject) {
                    this.delegate.setValue(context, base, property, value);
                }
                context.setPropertyResolved(true);
                CapturingELContext.this.reference = new ValueReference(base, property, CapturingELContext.this.reference);
            }
        }

        public Object getValue(ELContext context, Object base, Object property) {
            GraphValidatorState graphValidatorState;
            CapturingELContext.this.reference = new ValueReference(base, property, CapturingELContext.this.reference);
            Object value = this.delegate.getValue(context, base, property);
            if (null != value && context.isPropertyResolved() && this.states.containsKey(value) && (graphValidatorState = this.states.get(value)).isActive()) {
                this.clonedObject = true;
                Object clone = graphValidatorState.getCloned();
                return clone;
            }
            return value;
        }

        public Class<?> getType(ELContext context, Object base, Object property) {
            if (base != null) {
                context.setPropertyResolved(true);
                CapturingELContext.this.reference = new ValueReference(base, property, CapturingELContext.this.reference);
            }
            return this.delegate.getType(context, base, property);
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) {
            return this.delegate.isReadOnly(context, base, property);
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            return this.delegate.getFeatureDescriptors(context, base);
        }

        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            return this.delegate.getCommonPropertyType(context, base);
        }
    }
}

