/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBQueryBuilder;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryDescriptor;

public class MongoDBRepository
extends DBSRepositoryBase {
    private static final Log log = LogFactory.getLog(MongoDBRepository.class);
    private static final Long ZERO = 0L;
    private static final Long ONE = 1L;
    private static final Long MINUS_ONE = -1L;
    public static final String DB_DEFAULT = "nuxeo";
    public static final String MONGODB_ID = "_id";
    public static final String MONGODB_INC = "$inc";
    public static final String MONGODB_SET = "$set";
    public static final String MONGODB_UNSET = "$unset";
    public static final String MONGODB_PUSH = "$push";
    public static final String MONGODB_EACH = "$each";
    public static final String MONGODB_META = "$meta";
    public static final String MONGODB_TEXT_SCORE = "textScore";
    private static final String MONGODB_INDEX_TEXT = "text";
    private static final String MONGODB_INDEX_NAME = "name";
    private static final String MONGODB_LANGUAGE_OVERRIDE = "language_override";
    private static final String FULLTEXT_INDEX_NAME = "fulltext";
    private static final String LANGUAGE_FIELD = "__language";
    protected static final String COUNTER_NAME_UUID = "ecm:id";
    protected static final String COUNTER_FIELD = "seq";
    protected MongoClient mongoClient;
    protected DBCollection coll;
    protected DBCollection countersColl;

    public MongoDBRepository(MongoDBRepositoryDescriptor descriptor) {
        super(descriptor.name, descriptor.getFulltextDisabled());
        try {
            this.mongoClient = MongoDBRepository.newMongoClient(descriptor);
            this.coll = MongoDBRepository.getCollection(descriptor, this.mongoClient);
            this.countersColl = MongoDBRepository.getCountersCollection(descriptor, this.mongoClient);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.initRepository();
    }

    public void shutdown() {
        super.shutdown();
        this.mongoClient.close();
    }

    public static MongoClient newMongoClient(MongoDBRepositoryDescriptor descriptor) throws UnknownHostException {
        String server = descriptor.server;
        if (StringUtils.isBlank((String)server)) {
            throw new NuxeoException("Missing <server> in MongoDB repository descriptor");
        }
        if (server.startsWith("mongodb://")) {
            return new MongoClient(new MongoClientURI(server));
        }
        return new MongoClient(new ServerAddress(server));
    }

    protected static DBCollection getCollection(MongoClient mongoClient, String dbname, String collection) {
        if (StringUtils.isBlank((String)dbname)) {
            dbname = DB_DEFAULT;
        }
        DB db = mongoClient.getDB(dbname);
        return db.getCollection(collection);
    }

    public static DBCollection getCollection(MongoDBRepositoryDescriptor descriptor, MongoClient mongoClient) {
        return MongoDBRepository.getCollection(mongoClient, descriptor.dbname, descriptor.name);
    }

    public static DBCollection getCountersCollection(MongoDBRepositoryDescriptor descriptor, MongoClient mongoClient) {
        return MongoDBRepository.getCollection(mongoClient, descriptor.dbname, descriptor.name + ".counters");
    }

    protected Object valueToBson(Object value) {
        if (value instanceof State) {
            return this.stateToBson((State)value);
        }
        if (value instanceof List) {
            List values = (List)value;
            return this.listToBson(values);
        }
        if (value instanceof Object[]) {
            return this.listToBson(Arrays.asList((Object[])value));
        }
        return this.serializableToBson(value);
    }

    protected DBObject stateToBson(State state) {
        BasicDBObject ob = new BasicDBObject();
        for (Map.Entry en : state.entrySet()) {
            Object val = this.valueToBson(en.getValue());
            if (val == null) continue;
            ob.put((String)en.getKey(), val);
        }
        return ob;
    }

    protected List<Object> listToBson(List<Object> values) {
        ArrayList<Object> objects = new ArrayList<Object>(values.size());
        for (Object value : values) {
            objects.add(this.valueToBson(value));
        }
        return objects;
    }

    protected State bsonToState(DBObject ob) {
        if (ob == null) {
            return null;
        }
        State state = new State(ob.keySet().size());
        for (String key : ob.keySet()) {
            Object value;
            Object val = ob.get(key);
            if (val instanceof List) {
                List list = (List)val;
                if (list.isEmpty()) {
                    value = null;
                } else if (list.get(0) instanceof DBObject) {
                    ArrayList<State> l = new ArrayList<State>(list.size());
                    for (Object el : list) {
                        l.add(this.bsonToState((DBObject)el));
                    }
                    value = l;
                } else {
                    Object[] ar = new Object[list.size()];
                    int i = 0;
                    for (Object el : list) {
                        ar[i++] = this.scalarToSerializable(el);
                    }
                    value = ar;
                }
            } else if (val instanceof DBObject) {
                value = this.bsonToState((DBObject)val);
            } else {
                if (MONGODB_ID.equals(key)) continue;
                value = this.scalarToSerializable(val);
            }
            state.put(key, (Serializable)value);
        }
        return state;
    }

    protected List<DBObject> diffToBson(State.StateDiff diff) {
        Updates updates = new Updates();
        this.diffToUpdates(diff, null, updates);
        UpdateListBuilder builder = new UpdateListBuilder();
        for (Map.Entry en : updates.set.entrySet()) {
            builder.update(MONGODB_SET, (String)en.getKey(), en.getValue());
        }
        for (Map.Entry en : updates.unset.entrySet()) {
            builder.update(MONGODB_UNSET, (String)en.getKey(), en.getValue());
        }
        for (Map.Entry en : updates.push.entrySet()) {
            builder.update(MONGODB_PUSH, (String)en.getKey(), en.getValue());
        }
        for (Map.Entry en : updates.inc.entrySet()) {
            builder.update(MONGODB_INC, (String)en.getKey(), en.getValue());
        }
        return builder.updateList;
    }

    protected void diffToUpdates(State.StateDiff diff, String prefix, Updates updates) {
        String elemPrefix = prefix == null ? "" : prefix + '.';
        for (Map.Entry en : diff.entrySet()) {
            String name = elemPrefix + (String)en.getKey();
            Serializable value = (Serializable)en.getValue();
            if (value instanceof State.StateDiff) {
                this.diffToUpdates((State.StateDiff)value, name, updates);
                continue;
            }
            if (value instanceof State.ListDiff) {
                this.diffToUpdates((State.ListDiff)value, name, updates);
                continue;
            }
            if (value instanceof Delta) {
                this.diffToUpdates((Delta)value, name, updates);
                continue;
            }
            updates.set.put(name, this.valueToBson(value));
        }
    }

    protected void diffToUpdates(State.ListDiff listDiff, String prefix, Updates updates) {
        if (listDiff.diff != null) {
            String elemPrefix = prefix == null ? "" : prefix + '.';
            int i = 0;
            for (Object value : listDiff.diff) {
                String name = elemPrefix + i;
                if (value instanceof State.StateDiff) {
                    this.diffToUpdates((State.StateDiff)value, name, updates);
                } else if (value != State.NOP) {
                    updates.set.put(name, this.valueToBson(value));
                }
                ++i;
            }
        }
        if (listDiff.rpush != null) {
            Object pushed = listDiff.rpush.size() == 1 ? this.valueToBson(listDiff.rpush.get(0)) : new BasicDBObject(MONGODB_EACH, this.listToBson(listDiff.rpush));
            updates.push.put(prefix, pushed);
        }
    }

    protected void diffToUpdates(Delta delta, String prefix, Updates updates) {
        Object inc = this.valueToBson(delta.getDeltaValue());
        updates.inc.put(prefix, inc);
    }

    protected Object serializableToBson(Object value) {
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        return value;
    }

    protected Serializable scalarToSerializable(Object val) {
        if (val instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)val);
            return cal;
        }
        return (Serializable)val;
    }

    protected void initRepository() {
        BasicDBObject query;
        this.coll.createIndex((DBObject)new BasicDBObject(COUNTER_NAME_UUID, (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:parentId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:ancestorIds", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:versionSeriesId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:proxyTargetId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:proxyVersionSeriesId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:primaryType", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:lifeCycleState", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("ecm:fulltextJobId", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("rend:renditionName", (Object)ONE));
        this.coll.createIndex((DBObject)new BasicDBObject("drv:subscriptions.enabled", (Object)ONE));
        if (!this.fulltextDisabled) {
            BasicDBObject indexKeys = new BasicDBObject();
            indexKeys.put("ecm:fulltextSimple", (Object)MONGODB_INDEX_TEXT);
            indexKeys.put("ecm:fulltextBinary", (Object)MONGODB_INDEX_TEXT);
            BasicDBObject indexOptions = new BasicDBObject();
            indexOptions.put(MONGODB_INDEX_NAME, (Object)FULLTEXT_INDEX_NAME);
            indexOptions.put(MONGODB_LANGUAGE_OVERRIDE, (Object)LANGUAGE_FIELD);
            this.coll.createIndex((DBObject)indexKeys, (DBObject)indexOptions);
        }
        if (this.coll.findOne((DBObject)(query = new BasicDBObject(COUNTER_NAME_UUID, (Object)this.getRootId())), this.justPresenceField()) != null) {
            return;
        }
        this.initRoot();
    }

    protected Long getNextUuidSeq() {
        BasicDBObject query = new BasicDBObject(MONGODB_ID, (Object)COUNTER_NAME_UUID);
        BasicDBObject update = new BasicDBObject(MONGODB_INC, (Object)new BasicDBObject(COUNTER_FIELD, (Object)ONE));
        boolean returnNew = true;
        DBObject idCounter = this.countersColl.findAndModify((DBObject)query, null, null, false, (DBObject)update, returnNew, false);
        if (idCounter == null) {
            throw new RuntimeException("Repository id counter not initialized");
        }
        return (Long)idCounter.get(COUNTER_FIELD);
    }

    public String generateNewId() {
        return UUID.randomUUID().toString();
    }

    public void createState(State state) throws DocumentException {
        DBObject ob = this.stateToBson(state);
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: CREATE " + ob));
        }
        this.coll.insert(new DBObject[]{ob});
    }

    public State readState(String id) {
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)id);
        return this.findOne((DBObject)query);
    }

    public List<State> readStates(List<String> ids) {
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)new BasicDBObject("$in", ids));
        return this.findAll((DBObject)query, ids.size());
    }

    public void updateState(String id, State.StateDiff diff) throws DocumentException {
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)id);
        for (DBObject update : this.diffToBson(diff)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("MongoDB: UPDATE " + id + ": " + update));
            }
            this.coll.update((DBObject)query, update);
        }
    }

    public void deleteStates(Set<String> ids) throws DocumentException {
        WriteResult w;
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)new BasicDBObject("$in", ids));
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: REMOVE " + ids));
        }
        if ((w = this.coll.remove((DBObject)query)).getN() != ids.size()) {
            log.error((Object)("Removed " + w.getN() + " docs for " + ids.size() + " ids: " + ids));
        }
    }

    public State readChildState(String parentId, String name, Set<String> ignored) {
        DBObject query = this.getChildQuery(parentId, name, ignored);
        return this.findOne(query);
    }

    public boolean hasChild(String parentId, String name, Set<String> ignored) {
        DBObject query = this.getChildQuery(parentId, name, ignored);
        return this.coll.findOne(query, this.justPresenceField()) != null;
    }

    protected DBObject getChildQuery(String parentId, String name, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject();
        query.put("ecm:parentId", (Object)parentId);
        query.put("ecm:name", (Object)name);
        this.addIgnoredIds((DBObject)query, ignored);
        return query;
    }

    protected void addIgnoredIds(DBObject query, Set<String> ignored) {
        if (!ignored.isEmpty()) {
            BasicDBObject notInIds = new BasicDBObject("$nin", new ArrayList<String>(ignored));
            query.put(COUNTER_NAME_UUID, (Object)notInIds);
        }
    }

    public List<State> queryKeyValue(String key, String value, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject(key, (Object)value);
        this.addIgnoredIds((DBObject)query, ignored);
        return this.findAll((DBObject)query, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryKeyValueArray(String key, Object value, Set<String> ids, Map<String, String> proxyTargets, Map<String, Object[]> targetProxies) {
        BasicDBObject query = new BasicDBObject(key, value);
        BasicDBObject fields = new BasicDBObject();
        fields.put(MONGODB_ID, (Object)ZERO);
        fields.put(COUNTER_NAME_UUID, (Object)ONE);
        fields.put("ecm:isProxy", (Object)ONE);
        fields.put("ecm:proxyTargetId", (Object)ONE);
        fields.put("ecm:proxyIds", (Object)ONE);
        try (DBCursor cursor = this.coll.find((DBObject)query, (DBObject)fields);){
            for (DBObject ob : cursor) {
                Object[] proxyIds;
                String id = (String)ob.get(COUNTER_NAME_UUID);
                ids.add(id);
                if (proxyTargets != null && Boolean.TRUE.equals(ob.get("ecm:isProxy"))) {
                    String targetId = (String)ob.get("ecm:proxyTargetId");
                    proxyTargets.put(id, targetId);
                }
                if (targetProxies == null || (proxyIds = (Object[])ob.get("ecm:proxyIds")) == null) continue;
                targetProxies.put(id, proxyIds);
            }
        }
    }

    public boolean queryKeyValuePresence(String key, String value, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject(key, (Object)value);
        this.addIgnoredIds((DBObject)query, ignored);
        return this.coll.findOne((DBObject)query, this.justPresenceField()) != null;
    }

    protected State findOne(DBObject query) {
        return this.bsonToState(this.coll.findOne(query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<State> findAll(DBObject query, int sizeHint) {
        HashSet<String> seen = new HashSet<String>();
        try (DBCursor cursor = this.coll.find(query);){
            ArrayList<State> list = new ArrayList<State>(sizeHint);
            for (DBObject ob : cursor) {
                if (!seen.add((String)ob.get(COUNTER_NAME_UUID))) continue;
                list.add(this.bsonToState(ob));
            }
            ArrayList<State> arrayList = list;
            return arrayList;
        }
    }

    protected DBObject justPresenceField() {
        return new BasicDBObject(MONGODB_ID, (Object)ONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartialList<State> queryAndFetch(Expression expression, DBSExpressionEvaluator evaluator, OrderByClause orderByClause, int limit, int offset, int countUpTo, boolean deepCopy, boolean fulltextScore) {
        long totalSize;
        ArrayList<State> list;
        BasicDBObject keys;
        BasicDBObject orderBy;
        MongoDBQueryBuilder builder = new MongoDBQueryBuilder(evaluator.pathResolver);
        DBObject query = builder.walkExpression(expression);
        if (builder.hasFulltext && this.fulltextDisabled) {
            throw new RuntimeException("Fulltext disabled by configuration");
        }
        this.addPrincipals(query, evaluator.principals);
        boolean sortScore = false;
        if (orderByClause == null) {
            orderBy = null;
        } else {
            orderBy = new BasicDBObject();
            for (OrderByExpr ob : orderByClause.elements) {
                Long value;
                Reference ref = ob.reference;
                boolean desc = ob.isDescending;
                String field = builder.walkReference((Reference)ref).field;
                if (orderBy.containsField(field)) continue;
                if ("ecm:fulltextScore".equals(field)) {
                    if (!desc) {
                        throw new RuntimeException("Cannot sort by ecm:fulltextScore ascending");
                    }
                    sortScore = true;
                    value = new BasicDBObject(MONGODB_META, (Object)MONGODB_TEXT_SCORE);
                } else {
                    value = desc ? MINUS_ONE : ONE;
                }
                orderBy.put(field, (Object)value);
            }
            if (sortScore && orderBy.size() > 1) {
                throw new RuntimeException("Cannot sort by ecm:fulltextScore and other criteria");
            }
        }
        if (fulltextScore || sortScore) {
            if (!builder.hasFulltext) {
                throw new RuntimeException("ecm:fulltextScore cannot be used without ecm:fulltext");
            }
            keys = new BasicDBObject("ecm:fulltextScore", (Object)new BasicDBObject(MONGODB_META, (Object)MONGODB_TEXT_SCORE));
        } else {
            keys = null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: QUERY " + query + (orderBy == null ? "" : " ORDER BY " + orderBy) + " OFFSET " + offset + " LIMIT " + limit));
        }
        try (DBCursor cursor = this.coll.find(query, keys).skip(offset).limit(limit);){
            if (orderBy != null) {
                cursor = cursor.sort((DBObject)orderBy);
            }
            list = new ArrayList<State>();
            for (DBObject ob : cursor) {
                list.add(this.bsonToState(ob));
            }
            if (countUpTo == -1) {
                totalSize = limit == 0 ? (long)list.size() : (long)cursor.count();
            } else if (countUpTo == 0) {
                totalSize = -1L;
            } else {
                totalSize = limit == 0 ? (long)list.size() : (long)cursor.copy().limit(countUpTo + 1).count();
                if (totalSize > (long)countUpTo) {
                    totalSize = -2L;
                }
            }
        }
        if (log.isTraceEnabled() && list.size() != 0) {
            log.trace((Object)("MongoDB:    -> " + list.size()));
        }
        return new PartialList(list, totalSize);
    }

    protected void addPrincipals(DBObject query, Set<String> principals) {
        if (principals != null) {
            BasicDBObject inPrincipals = new BasicDBObject("$in", new ArrayList<String>(principals));
            query.put("ecm:racl", (Object)inPrincipals);
        }
    }

    protected static class UpdateListBuilder {
        protected List<DBObject> updateList = new ArrayList<DBObject>(1);
        protected DBObject update;
        protected List<String> keys;

        protected UpdateListBuilder() {
            this.newUpdate();
        }

        protected void newUpdate() {
            this.update = new BasicDBObject();
            this.updateList.add(this.update);
            this.keys = new ArrayList<String>();
        }

        protected void update(String op, String key, Object value) {
            if (this.conflicts(key, this.keys)) {
                this.newUpdate();
            }
            this.keys.add(key);
            DBObject map = (DBObject)this.update.get(op);
            if (map == null) {
                map = new BasicDBObject();
                this.update.put(op, (Object)map);
            }
            map.put(key, value);
        }

        protected boolean conflicts(String key, List<String> previousKeys) {
            String keydot = key + '.';
            for (String prev : previousKeys) {
                if (!prev.equals(key) && !prev.startsWith(keydot) && !key.startsWith(prev + '.')) continue;
                return true;
            }
            return false;
        }
    }

    public static class Updates {
        public BasicDBObject set = new BasicDBObject();
        public BasicDBObject unset = new BasicDBObject();
        public BasicDBObject push = new BasicDBObject();
        public BasicDBObject inc = new BasicDBObject();
    }
}

