/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.mode.service;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.runtime.model.DefaultComponent;

public class SegmentService
extends DefaultComponent {
    public static final String SIBLINGS_QUERY = "select * from Document where ecm:parentId = '%s' and ecm:uuid <> '%s' and ottcweb:segment = '%s' and ecm:isVersion = 0 and ecm:isProxy = 0 and ecm:currentLifeCycleState <> 'deleted'";

    public boolean supportsWebUrls(CoreSession session, DocumentModel currentDocument) {
        String query;
        DocumentModelList portalSitesWithWebUrls;
        boolean supports = false;
        DocumentModel domain = ToutaticeDocumentHelper.getDomain((CoreSession)session, (DocumentModel)currentDocument, (boolean)true);
        if (domain != null && CollectionUtils.isNotEmpty((Collection)(portalSitesWithWebUrls = session.query(String.format(query = "select * from PortalSite where ecm:ancestorId = '%s' and ottcwebc:enableWebUrl = 1".concat(" and ecm:isProxy = 0 and ecm:isVersion = 0 and ecm:currentLifeCycleState <> 'deleted'"), domain.getId())))) && portalSitesWithWebUrls.size() >= 1) {
            boolean isChild = false;
            Iterator iterator = portalSitesWithWebUrls.iterator();
            while (iterator.hasNext() && !isChild) {
                DocumentModel portalSite = (DocumentModel)iterator.next();
                if (!StringUtils.contains((String)currentDocument.getPathAsString(), (String)portalSite.getPathAsString())) continue;
                isChild = true;
                supports = true;
            }
            if (!isChild && currentDocument.hasFacet("hasWebUrl")) {
                supports = true;
            }
        }
        return supports;
    }

    public String createSegment(CoreSession session, DocumentModel document) {
        String initialSegment = (String)((Object)document.getPropertyValue("ottcweb:segment"));
        if (StringUtils.isBlank((String)initialSegment)) {
            initialSegment = this.generateSegment(document);
        }
        String segment = initialSegment;
        int increment = 1;
        while (!this.isUniqueSegment(session, document, segment)) {
            segment = this.getNextSegment(initialSegment, increment);
            ++increment;
        }
        return segment;
    }

    public boolean isUniqueSegment(CoreSession session, DocumentModel document, String segment) {
        DocumentModel parent = session.getParentDocument(document.getRef());
        if (parent != null) {
            DocumentModelList siblings = session.query(String.format(SIBLINGS_QUERY, parent.getId(), document.getId(), segment));
            return CollectionUtils.isEmpty((Collection)siblings);
        }
        return false;
    }

    protected String generateSegment(DocumentModel document) {
        String title = document.getTitle();
        return IdUtils.generateId((String)title, (String)"-", (boolean)true, (int)30);
    }

    private String getNextSegment(String segment, int increment) {
        return segment.concat(String.valueOf(increment));
    }
}

