/*
 * Decompiled with CFR 0.152.
 */
package fr.edu.lyon.nuxeo.serializer;

import fr.edu.lyon.nuxeo.linker.api.FieldLinkService;
import fr.edu.lyon.nuxeo.restAPI.DatasetResultSummary;
import fr.edu.lyon.nuxeo.serializer.ExtendedResultField;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.platform.syndication.serializer.AbstractDocumentModelSerializer;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Response;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DATASETSerializer
extends AbstractDocumentModelSerializer {
    private static Log log = LogFactory.getLog(DATASETSerializer.class);
    private static final String rootNodeName = "dataset";
    private static final String docNodeName = "data";
    private static final String fieldNodeName = "field";
    private static final String valueNodeName = "value";
    private static final String file = "ecm:file";
    private static final String otherfiles = "ecm:files";
    private static final String version = "ecm:version";
    private static final String acls = "ecm:acls";
    private static final DateFormat DATE_PARSER = new SimpleDateFormat("dd/MM/yyyy");
    protected static String SchemaDelimiter = ":";
    private CoreSession session;
    private SchemaManager schemaManager;
    private FieldLinkService fieldLinkService;
    protected UserManager userManager;

    protected ExtendedResultField getDocumentProperty(DocumentModel doc, String colDef) throws ClientException {
        ExtendedResultField res = null;
        if (colDef.equals("url")) {
            String url = DATASETSerializer.getDocumentURL((DocumentModel)doc);
            return new ExtendedResultField("url", url);
        }
        if (colDef.contains("path")) {
            String path = doc.getPath().toString();
            return new ExtendedResultField("path", path);
        }
        if (colDef.equals("type")) {
            String type = doc.getType();
            return new ExtendedResultField("type", type);
        }
        if (colDef.equals("currentLifecycleState")) {
            String state = doc.getCurrentLifeCycleState();
            return new ExtendedResultField("currentLifecycleState", state);
        }
        if (colDef.contains("author")) {
            String authorLogin = (String)doc.getProperty("dublincore", "creator");
            try {
                String author = this.getFullUserName(authorLogin);
                return new ExtendedResultField("author", author);
            }
            catch (Exception e) {
                return new ExtendedResultField("author", authorLogin);
            }
        }
        if (colDef.contains(version)) {
            String version = "";
            if (doc.hasFacet("Versionable")) {
                version = doc.getProperty("uid", "major_version") + "." + doc.getProperty("uid", "minor_version");
            }
            return new ExtendedResultField(version, version);
        }
        if (colDef.contains(SchemaDelimiter)) {
            String[] params = colDef.split("\\" + SchemaDelimiter);
            if (params.length == 2) {
                String schemaName = params[0].trim();
                String fieldName = params[1].trim();
                Schema schema = this.getSchemaManager().getSchemaFromPrefix(schemaName);
                if (schema != null) {
                    schemaName = schema.getName();
                }
                if (fieldName.contains("[")) {
                    int pos = fieldName.indexOf("[");
                    String sIndex = fieldName.substring(pos + 1, pos + 2);
                    String realFieldName = fieldName.substring(0, pos);
                    List<Object> list = Arrays.asList((Object[])doc.getProperty(schemaName, realFieldName));
                    if (list != null && !list.isEmpty()) {
                        String id = list.get(Integer.parseInt(sIndex)).toString();
                        return new ExtendedResultField(fieldName, this.getLinkedValue(this.session, schemaName, realFieldName, id), id);
                    }
                    return null;
                }
                Object property = doc.getProperty(schemaName, fieldName);
                if (property instanceof String) {
                    res = new ExtendedResultField(fieldName, this.getLinkedValue(this.session, schemaName, fieldName, (String)property), (String)property);
                } else if (property instanceof Long) {
                    res = new ExtendedResultField(fieldName, property.toString());
                } else if (property instanceof Calendar) {
                    String date = DATE_PARSER.format(((Calendar)property).getTime());
                    res = new ExtendedResultField(fieldName, date);
                } else if (property instanceof Object[]) {
                    List<String> list = Arrays.asList((String[])property);
                    res = new ExtendedResultField(fieldName, this.getLinkedValue(this.session, schemaName, fieldName, list), list);
                } else if (property instanceof List) {
                    List list = (List)property;
                    res = new ExtendedResultField(fieldName, this.getLinkedValue(this.session, schemaName, fieldName, list), list);
                } else {
                    res = new ExtendedResultField(fieldName, null);
                }
            } else {
                res = new ExtendedResultField(colDef, null);
            }
        } else {
            String result = null;
            String[] stringArray = doc.getSchemas();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String schemaName = stringArray[n2];
                result = (String)doc.getProperty(schemaName, colDef);
                if (result != null) {
                    // empty if block
                }
                ++n2;
            }
            res = new ExtendedResultField(colDef, result);
        }
        return res;
    }

    public void serialize(CoreSession session, DatasetResultSummary summary, DocumentModelList docList, String columnsDefinition, Response res, HttpServletRequest req) throws ClientException {
        String xml = this.serialize(session, summary, docList, Arrays.asList(columnsDefinition.split(",")), req);
        res.setEntity(xml, MediaType.TEXT_XML);
        res.getEntity().setCharacterSet(CharacterSet.UTF_8);
    }

    public String serialize(CoreSession session, DatasetResultSummary summary, DocumentModelList docList, List<String> columnsDefinition, HttpServletRequest req) throws ClientException {
        if (docList == null) {
            return "empty result";
        }
        this.session = session;
        DOMDocumentFactory domfactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domfactory.createDocument();
        Element current = result.createElement(rootNodeName);
        result.setRootElement((org.dom4j.Element)current);
        Element pagesElement = result.createElement("pager");
        pagesElement.setAttribute("total", Long.toString(summary.getTotal()));
        pagesElement.setAttribute("start", Long.toString(summary.getStart()));
        pagesElement.setAttribute("pagesize", Long.toString(summary.getPageSize()));
        pagesElement.setAttribute("currentPage", Long.toString(summary.getPageNumber()));
        pagesElement.setAttribute("pages", Long.toString(summary.getPages()));
        current.appendChild(pagesElement);
        Element summaryElement = result.createElement("summary");
        summaryElement.setAttribute("base", summary.getLink());
        current.appendChild(summaryElement);
        for (DocumentModel doc : docList) {
            Element el = result.createElement(docNodeName);
            el.setAttribute("id", doc.getId());
            if (columnsDefinition.contains(file) && doc.hasSchema("file")) {
                Element file = result.createElement("file");
                String filename = (String)doc.getProperty("file", "filename");
                file.setAttribute("url", DocumentModelFunctions.fileUrl((String)"downloadFile", (DocumentModel)doc, (String)"blobholder:0", (String)filename));
                file.setAttribute("filename", filename);
                file.setAttribute("icon", DocumentModelFunctions.iconPath((DocumentModel)doc));
                el.appendChild(file);
            }
            if (columnsDefinition.contains(otherfiles) && doc.hasSchema("files")) {
                Element files = result.createElement("files");
                List listFiles = (List)doc.getProperty("files", "files");
                int i = 0;
                while (i < listFiles.size()) {
                    Map blob = (Map)listFiles.get(i);
                    Element file = result.createElement("file");
                    String filename = (String)blob.get("filename");
                    file.setAttribute("url", DocumentModelFunctions.complexFileUrl((String)"downloadFile", (DocumentModel)doc, (String)"files:files", (int)i, (String)"file", (String)filename));
                    file.setAttribute("filename", filename);
                    file.setAttribute("icon", DocumentModelFunctions.fileIconPath((Blob)((Blob)blob.get("file"))));
                    files.appendChild(file);
                    ++i;
                }
                el.appendChild(files);
            }
            if (columnsDefinition.contains(acls)) {
                ACP acp = doc.getACP();
                String[] users = this.getUsersForReadPermission(acp);
                Element readers = result.createElement("readers");
                String[] stringArray = users;
                int filename = users.length;
                int file = 0;
                while (file < filename) {
                    String user = stringArray[file];
                    Element reader = result.createElement("reader");
                    Text text = result.createTextNode(user);
                    reader.appendChild(text);
                    readers.appendChild(reader);
                    ++file;
                }
                el.appendChild(readers);
            }
            for (String colDef : columnsDefinition) {
                ExtendedResultField res;
                if (colDef.equals(file) || colDef.equals(otherfiles) || colDef.equals(acls) || (res = this.getDocumentProperty(doc, colDef)) == null) continue;
                if (colDef.equals("url")) {
                    el.setAttribute("url", res.getValue());
                    continue;
                }
                Element child = result.createElement(fieldNodeName);
                child.setAttribute("name", res.getName());
                if (res.isMultiValued()) {
                    child.setAttribute("type", "multi");
                    int i = 0;
                    while (i < res.getValues().size()) {
                        Element subchild = result.createElement(valueNodeName);
                        if (res.getIds() != null && res.getIds().size() > i && res.getIds().get(i) != null) {
                            subchild.setAttribute("id", res.getIds().get(i));
                        }
                        CDATASection value = result.createCDATASection(res.getValues().get(i));
                        subchild.appendChild(value);
                        child.appendChild(subchild);
                        ++i;
                    }
                } else {
                    Element subchild = result.createElement(valueNodeName);
                    if (res.getId() != null) {
                        subchild.setAttribute("id", res.getId());
                    }
                    CDATASection value = result.createCDATASection(res.getValue());
                    subchild.appendChild(value);
                    child.appendChild(subchild);
                }
                el.appendChild(child);
            }
            current.appendChild(el);
        }
        return result.asXML();
    }

    private List<String> getLinkedValue(CoreSession session, String schemaName, String fieldName, List<String> values) {
        ArrayList<String> labels = new ArrayList<String>();
        int i = 0;
        while (i < values.size()) {
            String value = values.get(i);
            if (value instanceof String) {
                labels.add(this.getLinkedValue(session, schemaName, fieldName, value));
            } else {
                labels.add(value.toString());
            }
            ++i;
        }
        return labels;
    }

    private SchemaManager getSchemaManager() {
        if (this.schemaManager == null) {
            this.schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        }
        return this.schemaManager;
    }

    private FieldLinkService getFieldLinkService() {
        if (this.fieldLinkService == null) {
            try {
                this.fieldLinkService = (FieldLinkService)Framework.getService(FieldLinkService.class);
            }
            catch (Exception e) {
                log.error((Object)"FieldLink Service injoignable");
            }
        }
        return this.fieldLinkService;
    }

    private UserManager getUserManager() {
        if (this.userManager == null) {
            try {
                this.userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                log.error((Object)"UserManager injoignable");
            }
        }
        return this.userManager;
    }

    private String getLinkedValue(CoreSession session, String schemaName, String fieldName, String value) {
        return this.getFieldLinkService().getLinkedValue(session, schemaName, fieldName, value);
    }

    protected List<String> getLeafPermissions(String perm) throws ClientException {
        PermissionProvider permissionProvider;
        ArrayList<String> permissions = new ArrayList<String>();
        try {
            permissionProvider = (PermissionProvider)Framework.getService(PermissionProvider.class);
        }
        catch (Exception e) {
            throw new Error("An unexpected error occured", e);
        }
        String[] subpermissions = permissionProvider.getSubPermissions(perm);
        if (subpermissions == null || subpermissions.length <= 0) {
            permissions.add(perm);
            return permissions;
        }
        String[] stringArray = subpermissions;
        int n = subpermissions.length;
        int n2 = 0;
        while (n2 < n) {
            String subperm = stringArray[n2];
            permissions.addAll(this.getLeafPermissions(subperm));
            ++n2;
        }
        return permissions;
    }

    public String[] getUsersForReadPermission(ACP acp) {
        HashSet<String> groups = new HashSet<String>();
        ACL merged = acp.getMergedACLs("merged");
        ArrayList<ACE> filteredACEbyPerm = new ArrayList<ACE>();
        List<String> currentPermissions = null;
        try {
            currentPermissions = this.getLeafPermissions("Read");
            ACE[] aCEArray = merged.getACEs();
            int n = aCEArray.length;
            int n2 = 0;
            while (n2 < n) {
                ACE ace = aCEArray[n2];
                List<String> acePermissions = this.getLeafPermissions(ace.getPermission());
                if ("Everything".equals(ace.getPermission())) {
                    try {
                        acePermissions = Arrays.asList(((PermissionProvider)Framework.getService(PermissionProvider.class)).getPermissions());
                    }
                    catch (Exception e) {
                        throw new Error("An unexpected error occured", e);
                    }
                }
                if (acePermissions.containsAll(currentPermissions)) {
                    if ("Everyone".equals(ace.getUsername()) && !ace.isGranted()) {
                        if (!"Everything".equals(ace.getPermission())) {
                            filteredACEbyPerm.clear();
                        }
                    } else {
                        filteredACEbyPerm.add(ace);
                    }
                }
                ++n2;
            }
        }
        catch (ClientException e2) {
            throw new Error("An unexpected error occured", e2);
        }
        for (ACE ace : filteredACEbyPerm) {
            try {
                List admins;
                String aceUsername = ace.getUsername();
                if ("Everyone".equals(aceUsername)) {
                    groups.add("Tout le monde");
                    continue;
                }
                if (!ace.isGranted() || this.getUserManager().getGroup(aceUsername) == null || (admins = this.getUserManager().getAdministratorsGroups()).contains(aceUsername)) continue;
                groups.add(aceUsername);
            }
            catch (Exception e) {
                throw new Error("An unexpected error occured while getting user ids", e);
            }
        }
        return groups.toArray(new String[groups.size()]);
    }
}

