/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.cns.cas.adaptors.ldap;

import java.util.regex.Matcher;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Rdn;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.adaptors.ldap.AbstractLdapUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.jasig.cas.util.LdapUtils;

public abstract class AbstractUsernamePasswordAuthenticationHandler
extends AbstractLdapUsernamePasswordAuthenticationHandler {
    public AbstractUsernamePasswordAuthenticationHandler(Class<? extends UsernamePasswordCredentials> type) {
        this.setClassToSupport(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials credentials) throws AuthenticationException {
        boolean result;
        credentials.setUsername(StringUtils.lowerCase((String)credentials.getUsername()));
        DirContext dirContext = null;
        try {
            String transformedUsername = Rdn.escapeValue(this.getPrincipalNameTransformer().transform(credentials.getUsername()));
            String bindDn = this.getFilter().replaceAll("%u", Matcher.quoteReplacement(transformedUsername));
            dirContext = this.getContextSource().getContext(bindDn, credentials.getPassword());
            boolean bl = result = dirContext != null;
            if (dirContext == null) return result;
        }
        catch (Exception e) {
            result = false;
            return result;
        }
        finally {
            if (dirContext != null) {
                LdapUtils.closeContext(dirContext);
            }
        }
        LdapUtils.closeContext((DirContext)dirContext);
        return result;
    }
}

