/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.cns.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SetupAction
extends AbstractAction {
    private final String publicUrl;

    public SetupAction(String publicUrl) {
        this.publicUrl = publicUrl;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        String host = request.getHeader("x-forwarded-host");
        boolean cns = BooleanUtils.toBoolean((String)request.getParameter("cns"));
        String service = request.getParameter("service");
        MutableAttributeMap flowScope = context.getFlowScope();
        boolean forums = !cns && (StringUtils.contains((String)host, (String)"forums") || StringUtils.contains((String)service, (String)"forums"));
        flowScope.put("forums", (Object)forums);
        flowScope.put("cnsPublicUrl", (Object)this.publicUrl);
        return this.success();
    }
}

