/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.session.impl;

import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webengine.jaxrs.session.CoreSessionProvider;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionRef;
import org.nuxeo.runtime.api.Framework;

public class PerSessionCoreProvider
extends CoreSessionProvider<Ref>
implements HttpSessionBindingListener {
    private static final Log log = LogFactory.getLog(PerSessionCoreProvider.class);

    public static synchronized void install(HttpServletRequest request) {
        HttpSession s = request.getSession(true);
        if (s.getAttribute(SessionFactory.SESSION_FACTORY_KEY) == null) {
            s.setAttribute(SessionFactory.SESSION_FACTORY_KEY, (Object)new PerSessionCoreProvider());
        }
    }

    @Override
    protected Ref createSessionRef(CoreSession session) {
        return new Ref(session);
    }

    @Override
    public void onRequestDone(HttpServletRequest request) {
        for (SessionRef ref : this.getSessions()) {
            ref.unget();
        }
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUnbound(HttpSessionBindingEvent event) {
        if (!this.hasSessions()) {
            this.destroy();
            return;
        }
        LoginContext lc = null;
        try {
            lc = Framework.login();
            this.destroy();
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        finally {
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException loginException) {}
            }
        }
    }

    @Override
    public synchronized SessionRef[] getSessions() {
        return super.getSessions();
    }

    @Override
    public synchronized SessionRef getSessionRef(HttpServletRequest request, String repoName) {
        return super.getSessionRef(request, repoName);
    }

    @Override
    public synchronized boolean hasSessions() {
        return super.hasSessions();
    }

    @Override
    protected synchronized void destroy() {
        super.destroy();
    }

    public static class Ref
    implements SessionRef {
        protected CoreSession session;
        protected ReentrantLock lock;

        public Ref(CoreSession session) {
            this.session = session;
            this.lock = new ReentrantLock();
        }

        @Override
        public CoreSession get() {
            this.lock.lock();
            return this.session;
        }

        @Override
        public void unget() {
            try {
                this.lock.unlock();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            try {
                this.session.close();
            }
            finally {
                this.session = null;
                this.lock = null;
            }
        }
    }
}

