/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.ContentType;
import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpClientHelper;
import com.noelios.restlet.util.HeaderReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.ReadableRepresentation;
import org.restlet.resource.Representation;
import org.restlet.service.ConnectorService;

public class HttpClientCall
extends HttpCall {
    private HttpClientHelper helper;

    public HttpClientCall(HttpClientHelper helper, String method, String requestUri) {
        this.setLogger(helper.getLogger());
        this.helper = helper;
        this.setMethod(method);
        this.setRequestUri(requestUri);
        this.setClientAddress(HttpClientCall.getLocalAddress());
    }

    public HttpClientHelper getHelper() {
        return this.helper;
    }

    public static String getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public WritableByteChannel getRequestChannel() {
        return null;
    }

    public OutputStream getRequestStream() {
        return null;
    }

    public Status sendRequest(Request request) {
        Status result = null;
        try {
            Representation entity;
            Representation representation = entity = request.isEntityAvailable() ? request.getEntity() : null;
            if (entity != null) {
                ConnectorService connectorService = this.getConnectorService(request);
                if (connectorService != null) {
                    connectorService.beforeSend(entity);
                }
                OutputStream rs = this.getRequestStream();
                WritableByteChannel wbc = this.getRequestChannel();
                if (wbc != null) {
                    if (entity != null) {
                        entity.write(wbc);
                    }
                } else if (rs != null) {
                    if (entity != null) {
                        entity.write(rs);
                    }
                    rs.flush();
                }
                if (connectorService != null) {
                    connectorService.afterSend(entity);
                }
                if (rs != null) {
                    rs.close();
                } else if (wbc != null) {
                    wbc.close();
                }
            }
            result = new Status(this.getStatusCode(), null, this.getReasonPhrase(), null);
        }
        catch (IOException ioe) {
            this.getHelper().getLogger().log(Level.FINE, "An error occured during the communication with the remote HTTP server.", ioe);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, "Unable to complete the HTTP call due to a communication error with the remote server. " + ioe.getMessage());
        }
        return result;
    }

    public ReadableByteChannel getResponseChannel() {
        return null;
    }

    public InputStream getResponseStream() {
        return null;
    }

    public Representation getResponseEntity() {
        Representation result = null;
        if (this.getResponseStream() != null) {
            result = new InputRepresentation(this.getResponseStream(), null);
        } else if (this.getResponseChannel() != null) {
            result = new ReadableRepresentation(this.getResponseChannel(), null);
        } else if (this.getMethod().equals(Method.HEAD.getName())) {
            result = new Representation(){

                public ReadableByteChannel getChannel() throws IOException {
                    return null;
                }

                public InputStream getStream() throws IOException {
                    return null;
                }

                public void write(OutputStream outputStream) throws IOException {
                }

                public void write(WritableByteChannel writableChannel) throws IOException {
                }
            };
        }
        if (result != null) {
            for (Parameter header : this.getResponseHeaders()) {
                String value;
                HeaderReader hr;
                if (header.getName().equalsIgnoreCase("Content-Type")) {
                    ContentType contentType = new ContentType(header.getValue());
                    if (contentType == null) continue;
                    result.setMediaType(contentType.getMediaType());
                    result.setCharacterSet(contentType.getCharacterSet());
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Content-Length")) {
                    result.setSize(Long.parseLong(header.getValue()));
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Expires")) {
                    result.setExpirationDate(this.parseDate(header.getValue(), false));
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Content-Encoding")) {
                    hr = new HeaderReader(header.getValue());
                    value = hr.readValue();
                    while (value != null) {
                        Encoding encoding = new Encoding(value);
                        if (!encoding.equals(Encoding.IDENTITY)) {
                            result.getEncodings().add(encoding);
                        }
                        value = hr.readValue();
                    }
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Content-Language")) {
                    hr = new HeaderReader(header.getValue());
                    value = hr.readValue();
                    while (value != null) {
                        result.getLanguages().add(new Language(value));
                        value = hr.readValue();
                    }
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Last-Modified")) {
                    result.setModificationDate(this.parseDate(header.getValue(), false));
                    continue;
                }
                if (header.getName().equalsIgnoreCase("ETag")) {
                    result.setTag(Tag.parse(header.getValue()));
                    continue;
                }
                if (!header.getName().equalsIgnoreCase("Content-Location")) continue;
                result.setIdentifier(header.getValue());
            }
        }
        return result;
    }
}

