/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.es.customizer.writers.impl;

import fr.toutatice.ecm.es.customizer.writers.api.AbstractCustomJsonESWriter;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;

public class DefaultCustomJsonESWriter
extends AbstractCustomJsonESWriter {
    @Override
    public boolean accept(DocumentModel doc) {
        return true;
    }

    @Override
    public void writeData(JsonGenerator jg, DocumentModel doc, String[] schemas, Map<String, String> contextParameters) throws IOException {
        this.writeLockInfos(jg, doc);
    }

    protected void writeLockInfos(JsonGenerator jg, DocumentModel doc) throws JsonGenerationException, IOException {
        Lock lock = doc.getLockInfo();
        if (lock != null) {
            jg.writeStringField("ttc:lockOwner", lock.getOwner());
            jg.writeStringField("ttc:lockCreated", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)lock.getCreated())));
        }
    }
}

