/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.seam;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailAdapter;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.util.RepositoryLocation;

@Name(value="thumbnailManager")
@Scope(value=ScopeType.CONVERSATION)
public class ThumbnailManagerBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(required=true, create=true)
    protected transient NavigationContext navigationContext;

    public void downloadThumbnail(DocumentView docView) throws ClientException {
        if (docView != null) {
            DocumentModel doc;
            DocumentLocation docLoc = docView.getDocumentLocation();
            if (this.documentManager == null) {
                RepositoryLocation loc = new RepositoryLocation(docLoc.getServerName());
                this.navigationContext.setCurrentServerLocation(loc);
                this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            }
            if ((doc = this.documentManager.getDocument(docLoc.getDocRef())) != null) {
                ThumbnailAdapter thumbnailDoc = (ThumbnailAdapter)doc.getAdapter(ThumbnailAdapter.class);
                Blob thumbnail = thumbnailDoc.getThumbnail(this.documentManager);
                if (thumbnail == null) {
                    return;
                }
                String filename = thumbnail.getFilename();
                FacesContext context = FacesContext.getCurrentInstance();
                ComponentUtils.download((FacesContext)context, (Blob)thumbnail, (String)filename);
            }
        }
    }
}

