/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.service;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osivia.migration.runners.AbstractRunner;
import org.osivia.migration.service.RunnerController;
import org.osivia.migration.service.RunnerDescriptor;
import org.osivia.migration.service.RunnerLauncherService;
import org.osivia.migration.transaction.LauncherTransactionHelper;

public class RunnerLauncherServiceImpl
extends DefaultComponent
implements RunnerLauncherService {
    private static final Log log = LogFactory.getLog(RunnerLauncherServiceImpl.class);
    private static final String RUNNERS_PT_EXT = "runners";
    private static final Map<String, RunnerDescriptor> runnersDescriptors = new HashMap<String, RunnerDescriptor>();

    public int getApplicationStartedOrder() {
        return 9999;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (RUNNERS_PT_EXT.equals(extensionPoint)) {
            RunnerDescriptor runnerDescriptor = (RunnerDescriptor)contribution;
            runnersDescriptors.put(runnerDescriptor.getRunnerId(), runnerDescriptor);
        }
    }

    @Override
    public void execute(CoreSession session, RunnerDescriptor runnerDescriptor, int batchSize, String params) {
        block13: {
            if (runnerDescriptor.isEnabled()) {
                try {
                    boolean toMigrate = RunnerController.needToMigrate(runnerDescriptor);
                    if (toMigrate) {
                        String runnerClass = runnerDescriptor.getClazz();
                        Class<?> runnerC = Class.forName(runnerClass);
                        Class[] constructorParams = new Class[]{CoreSession.class};
                        Constructor<?> constructor = runnerC.getDeclaredConstructor(constructorParams);
                        AbstractRunner runner = (AbstractRunner)((Object)constructor.newInstance(session));
                        if (params != null) {
                            runner.setParams(params);
                        }
                        long begin = System.currentTimeMillis();
                        if (batchSize > 0) {
                            this.runBatch(runnerDescriptor, batchSize, runner);
                        } else if (batchSize <= 0) {
                            this.runBatch(runnerDescriptor, -1, runner);
                        }
                        if (log.isDebugEnabled()) {
                            long end = System.currentTimeMillis();
                            log.debug((Object)("[===== End of " + runnerDescriptor.getRunnerId() + " migration : ".concat(String.valueOf(runner.getTreatedInputs())).concat(" on ").concat(String.valueOf(runner.getTotalInputs())).concat(" in ").concat(String.valueOf((end - begin) / 1000L)).concat(" s =====]")));
                            if (AbstractRunner.getDocsOnError().size() > 0) {
                                log.debug((Object)"[===== Documents on error =====]: ");
                                for (String uid : AbstractRunner.getDocsOnError()) {
                                    log.debug((Object)uid);
                                }
                            }
                        }
                        if (batchSize <= 0) {
                            AbstractRunner.resetDocsOnerror();
                        }
                        RunnerController.storeMigrationStatus(runnerDescriptor);
                        if (log.isDebugEnabled()) {
                            String status = toMigrate ? "Ended" : "Yet done";
                            log.debug((Object)("[" + runnerDescriptor.getRunnerId() + "] " + status));
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)("[" + runnerDescriptor.getRunnerId() + "] ERROR: "), (Throwable)e);
                    if (!log.isDebugEnabled()) break block13;
                    log.debug((Object)("[" + runnerDescriptor.getRunnerId() + "] ABORTED"));
                }
            }
        }
    }

    private boolean runBatch(RunnerDescriptor runnerDescriptor, int batchSize, AbstractRunner runner) {
        boolean stopBatchs = false;
        int totalInputs = this.getInputs(runner, 100);
        if (totalInputs > 0) {
            if (log.isDebugEnabled() && log.isDebugEnabled()) {
                log.debug((Object)("[===== Beginning of " + runnerDescriptor.getRunnerId() + " migration =====]"));
            }
            if (batchSize > 0) {
                while (totalInputs <= batchSize) {
                    runner.runSilentlyInTx(true);
                    int inputs = this.getInputs(runner, 100);
                    if (inputs > 0) {
                        totalInputs += inputs;
                        continue;
                    }
                    totalInputs += batchSize + 1;
                    stopBatchs = true;
                }
            } else if (batchSize == -1) {
                int inputs = totalInputs;
                while (inputs > 0) {
                    runner.runSilentlyInTx(true);
                    inputs = this.getInputs(runner, 100);
                }
                if (inputs <= 0) {
                    stopBatchs = true;
                }
            }
        } else {
            stopBatchs = true;
        }
        return stopBatchs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getInputs(AbstractRunner runner, int size) {
        LauncherTransactionHelper.checkNStartTransaction();
        int docsToTreat = 0;
        try {
            docsToTreat = runner.setInputs(size);
        }
        catch (Exception e) {
            LauncherTransactionHelper.setTransactionRollbackOnly();
            log.error((Object)e);
        }
        finally {
            LauncherTransactionHelper.commitOrRollbackTransaction();
        }
        return docsToTreat;
    }

    @Override
    public RunnerDescriptor getRunner(String id) {
        return runnersDescriptors.get(id);
    }
}

