/*
 * Decompiled with CFR 0.152.
 */
package com.osivia.cns.proto.massvalidation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeOperationHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;

public class MassValidationListener
implements PostCommitEventListener {
    public static final String WITH_VALIDATION = "withValidation";
    private static final Log log = LogFactory.getLog(MassValidationListener.class);

    public void handleEvent(EventBundle events) throws ClientException {
        for (Event event : events) {
            MassValidationExecutor executor = new MassValidationExecutor(event.getContext().getCoreSession(), event);
            executor.silentRun(true);
        }
    }

    private class MassValidationExecutor
    extends ToutaticeSilentProcessRunnerHelper {
        private Event event;

        public MassValidationExecutor(CoreSession session, Event event) {
            super(session);
            this.event = event;
        }

        public void run() throws ClientException {
            EventContext ctx = this.event.getContext();
            Object rawlist = ctx.getArguments()[0];
            DocumentModelList listToSave = (DocumentModelList)rawlist;
            log.info((Object)("Application des metadonn\u00e9es [" + this.event.getTime() + "]"));
            HashMap propertiesToChange = new HashMap();
            for (Map.Entry property : ctx.getProperties().entrySet()) {
                if (!((String)property.getKey()).contains(":") || property.getValue() == null) continue;
                if (property.getValue() instanceof String) {
                    if (StringUtils.isNotBlank((String)((Serializable)property.getValue()).toString())) {
                        propertiesToChange.put(property.getKey(), ((Serializable)property.getValue()).toString());
                    }
                } else {
                    propertiesToChange.put(property.getKey(), (String)property.getValue());
                }
                log.info((Object)((String)property.getKey() + "->" + property.getValue()));
            }
            CoreSession coreSession = ctx.getCoreSession();
            for (DocumentModel child : listToSave) {
                try {
                    for (Map.Entry property : propertiesToChange.entrySet()) {
                        child.setPropertyValue((String)property.getKey(), (Serializable)property.getValue());
                    }
                    log.info((Object)("Traitement de " + child.getPathAsString()));
                }
                catch (PropertyNotFoundException pnfe) {
                    log.error((Object)("Traitement de " + child.getPathAsString() + " " + pnfe.getMessage()));
                }
            }
            Object[] t = new DocumentModel[listToSave.size()];
            coreSession.saveDocuments((DocumentModel[])listToSave.toArray(t));
            log.info((Object)("Fin de l'appliquation des metadonn\u00e9es [" + this.event.getTime() + "]"));
            if (ctx.getProperty(MassValidationListener.WITH_VALIDATION).equals(Boolean.TRUE)) {
                log.info((Object)("Validation en masse [" + this.event.getTime() + "]"));
                for (DocumentModel docToSave : listToSave) {
                    try {
                        ToutaticeOperationHelper.runOperationChain((CoreSession)docToSave.getCoreSession(), (String)"validateDocument", (Object)docToSave);
                    }
                    catch (ToutaticeException e) {
                        log.error((Object)("Traitement de " + docToSave.getPathAsString() + " " + e.getMessage()));
                    }
                }
                log.info((Object)("Fin de la validation en masse [" + this.event.getTime() + "]"));
            }
        }
    }
}

