/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.portalviews.adapter;

import fr.toutatice.ecm.platform.service.portalviews.adapter.PVPropertyDescriptor;
import fr.toutatice.ecm.platform.service.portalviews.adapter.WidgetMappingDescriptor;
import fr.toutatice.ecm.platform.service.portalviews.adapter.WidgetMappingTypeDescriptor;
import fr.toutatice.ecm.platform.service.portalviews.adapter.WidgetsAdapterDescriptor;
import fr.toutatice.ecm.platform.service.portalviews.adapter.WidgetsAdapterService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class WidgetsAdapterServiceImpl
extends DefaultComponent
implements WidgetsAdapterService {
    private static final long serialVersionUID = 4780443408803007026L;
    private static final Log log = LogFactory.getLog(WidgetsAdapterService.class);
    protected static final String ADAPTER_EXT_PT = "adapter";
    private static final String FROM_URL_PARAM = "fromUrl";
    private Map<String, String> widgetsNamesMappings = new HashMap<String, String>(0);
    private Map<String, Map<String, PVPropertyDescriptor[]>> widgetsTypesMappings = new HashMap<String, Map<String, PVPropertyDescriptor[]>>(0);
    private Map<String, List<String>> fieldsOfNxWidgets;
    private Map<String, List<String>> fieldsOfPvWidgets;
    private List<String> portalViewIds;
    private String currentPortalView;
    private String fromUrlParam;

    public int getApplicationStartedOrder() {
        return 2000;
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.portalViewIds = new ArrayList<String>(0);
        this.fromUrlParam = "";
        this.fieldsOfNxWidgets = new HashMap<String, List<String>>(0);
        this.fieldsOfPvWidgets = new HashMap<String, List<String>>(0);
    }

    @Override
    public Map<String, String> getWidgetsMappings() {
        return this.widgetsNamesMappings;
    }

    @Override
    public String getCurrentPortalView() {
        return this.currentPortalView;
    }

    @Override
    public boolean isInPortalViewContext() {
        boolean is = false;
        RestHelper restHelper = null;
        try {
            restHelper = (RestHelper)SeamComponentCallHelper.getSeamComponentByName((String)"restHelper");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (restHelper != null) {
            String viewId = "";
            DocumentView documentView = restHelper.getDocumentView();
            boolean fromUrlParamExists = false;
            if (documentView != null) {
                viewId = documentView.getViewId();
                this.fromUrlParam = documentView.getParameter(FROM_URL_PARAM);
            } else {
                FacesContext context = FacesContext.getCurrentInstance();
                viewId = context.getViewRoot().getViewId();
                fromUrlParamExists = this.isFromUrlParamExists(context);
            }
            this.currentPortalView = viewId;
            is = fromUrlParamExists || this.isPortalView(viewId);
        }
        return is;
    }

    private boolean isPortalView(String viewId) {
        boolean is = false;
        DefaultPortalViewId[] defaultPortalViewIds = DefaultPortalViewId.values();
        if (StringUtils.isNotBlank((String)viewId)) {
            for (DefaultPortalViewId defaultPortalViewId : defaultPortalViewIds) {
                is |= viewId.contains(defaultPortalViewId.name());
            }
            if (CollectionUtils.isNotEmpty(this.portalViewIds)) {
                for (String vId : this.portalViewIds) {
                    is |= viewId.contains(vId);
                }
            }
        }
        return is;
    }

    private boolean isFromUrlParamExists(FacesContext context) {
        boolean is = false;
        if (StringUtils.isNotBlank((String)this.fromUrlParam)) {
            Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
            Set params = requestParameterMap.entrySet();
            Iterator iterator = params.iterator();
            boolean fromUrlParamExists = false;
            while (iterator.hasNext() && !fromUrlParamExists) {
                Map.Entry param = iterator.next();
                if (!((String)param.getValue()).contains(this.fromUrlParam)) continue;
                is = fromUrlParamExists = true;
            }
        }
        return is;
    }

    @Override
    public List<String> getNxFields(String nxWidgetName) {
        List<String> fields = new ArrayList<String>(0);
        if (MapUtils.isNotEmpty(this.fieldsOfNxWidgets)) {
            fields = this.fieldsOfNxWidgets.get(nxWidgetName);
        }
        return fields;
    }

    @Override
    public List<String> getPvFields(String pvWidgetName) {
        List<String> fields = new ArrayList<String>(0);
        if (MapUtils.isNotEmpty(this.fieldsOfPvWidgets)) {
            fields = this.fieldsOfPvWidgets.get(pvWidgetName);
        }
        return fields;
    }

    @Override
    public Widget getPortalViewWidget(Widget nxWidget) throws Exception {
        Widget pvWidget = nxWidget;
        String nxWidgetName = nxWidget.getName();
        String pvWidgetName = this.widgetsNamesMappings.get(nxWidgetName);
        WebLayoutManager layoutManager = (WebLayoutManager)Framework.getLocalService(WebLayoutManager.class);
        if (StringUtils.isNotBlank((String)pvWidgetName)) {
            FacesContext context = FacesContext.getCurrentInstance();
            ELContext elContext = (ELContext)context.getAttributes().get("javax.faces.FACELET_CONTEXT");
            if (elContext != null && (pvWidget = layoutManager.getWidget((FaceletContext)elContext, pvWidgetName, null, nxWidget.getMode(), "#{value}", null)) != null) {
                pvWidget.setId("nxw_" + pvWidgetName);
            }
        } else {
            WidgetDefinition widgetDefinition = nxWidget.getDefinition();
            if (widgetDefinition != null) {
                String type = widgetDefinition.getType();
                Set<String> mappedTypes = this.widgetsTypesMappings.keySet();
                if (mappedTypes != null && mappedTypes.contains(type)) {
                    Map<String, PVPropertyDescriptor[]> mappedPvproperties = this.widgetsTypesMappings.get(type);
                    Set<String> mappedPvTypes = mappedPvproperties.keySet();
                    if (mappedPvTypes != null && mappedPvTypes.size() == 1) {
                        if (this.canOverride(nxWidget)) {
                            PVPropertyDescriptor[] pvPropertyDescriptors;
                            String pvType = mappedPvTypes.iterator().next();
                            if (!StringUtils.equals((String)type, (String)pvType)) {
                                widgetDefinition.setType(pvType);
                                FacesContext context = FacesContext.getCurrentInstance();
                                ELContext elContext = (ELContext)context.getAttributes().get("javax.faces.FACELET_CONTEXT");
                                if (elContext != null) {
                                    pvWidget = layoutManager.createWidget((FaceletContext)elContext, widgetDefinition, nxWidget.getMode(), nxWidget.getValueName(), new Widget[0]);
                                }
                                widgetDefinition.setType(type);
                            }
                            if ((pvPropertyDescriptors = mappedPvproperties.get(pvType)) != null && pvPropertyDescriptors.length > 0) {
                                for (PVPropertyDescriptor pvProp : pvPropertyDescriptors) {
                                    pvWidget.setProperty(pvProp.getName(), (Serializable)((Object)pvProp.getValue()));
                                }
                            }
                        }
                    } else {
                        throw new Exception("Widget type can be mapped with only one PortalView widget type");
                    }
                }
            }
        }
        return pvWidget;
    }

    protected boolean canOverride(Widget nxWidget) {
        String override = (String)((Object)nxWidget.getProperty("pvOverride"));
        if (StringUtils.isBlank((String)override)) {
            return true;
        }
        return BooleanUtils.isTrue((Boolean)BooleanUtils.toBoolean((String)override));
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ADAPTER_EXT_PT.equals(extensionPoint) && contribution instanceof WidgetsAdapterDescriptor) {
            WidgetsAdapterDescriptor widgetsAdapterDesc = (WidgetsAdapterDescriptor)contribution;
            WidgetMappingDescriptor[] mappings = widgetsAdapterDesc.getWidgetsNamesMapping();
            this.fillMappings(mappings);
            WidgetMappingTypeDescriptor[] widgetsTypesMapping = widgetsAdapterDesc.getWidgetsTypesMapping();
            this.fillTypeMappings(widgetsTypesMapping);
        }
    }

    protected void fillTypeMappings(WidgetMappingTypeDescriptor[] widgetsTypesMapping) {
        if (widgetsTypesMapping.length > 0) {
            for (WidgetMappingTypeDescriptor mappingDesc : widgetsTypesMapping) {
                String type = mappingDesc.getType();
                String pvType = mappingDesc.getPvType();
                if (StringUtils.isEmpty((String)pvType)) {
                    pvType = type;
                }
                PVPropertyDescriptor[] pvPropertiesDesc = mappingDesc.getPvProperties();
                HashMap<String, PVPropertyDescriptor[]> pvProperties = new HashMap<String, PVPropertyDescriptor[]>(0);
                pvProperties.put(pvType, pvPropertiesDesc);
                this.widgetsTypesMappings.put(type, pvProperties);
            }
        }
    }

    protected void fillMappings(WidgetMappingDescriptor[] mappings) {
        LayoutStore lStore = (LayoutStore)Framework.getService(LayoutStore.class);
        WebLayoutManager wlMng = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        for (WidgetMappingDescriptor mapping : mappings) {
            String nxWidget = mapping.getNxWidget();
            String pvWidget = mapping.getPvWidget();
            this.widgetsNamesMappings.put(nxWidget, pvWidget);
            WidgetDefinition pvWidgetDefinition = wlMng.getWidgetDefinition(pvWidget);
            WidgetDefinition nxWidgetDefinition = wlMng.getWidgetDefinition(nxWidget);
            if (nxWidgetDefinition == null) {
                List categories = lStore.getCategories();
                for (String category : categories) {
                    List layoutDefinitionNames = lStore.getLayoutDefinitionNames(category);
                    boolean defined = false;
                    Iterator iterator = layoutDefinitionNames.iterator();
                    while (iterator.hasNext() && !defined) {
                        String layoutDefinitionName = (String)iterator.next();
                        LayoutDefinition layoutDefinition = wlMng.getLayoutDefinition(layoutDefinitionName);
                        if (layoutDefinition == null || (nxWidgetDefinition = layoutDefinition.getWidgetDefinition(nxWidget)) == null) continue;
                        defined = true;
                    }
                }
            }
            if (nxWidgetDefinition == null) {
                log.error((Object)(nxWidget + " widget mapped with " + pvWidget + " not found"));
                continue;
            }
            List<String> nxFields = this.storeWidgetFields(nxWidget, nxWidgetDefinition);
            this.fieldsOfNxWidgets.put(nxWidget, nxFields);
            List<String> pvFields = this.storeWidgetFields(pvWidget, pvWidgetDefinition);
            this.fieldsOfPvWidgets.put(pvWidget, pvFields);
        }
    }

    private List<String> storeWidgetFields(String widgetName, WidgetDefinition widgetDefinition) {
        ArrayList<String> fields = new ArrayList<String>();
        FieldDefinition[] fieldDefinitions = widgetDefinition.getFieldDefinitions();
        if (fieldDefinitions != null) {
            for (FieldDefinition nxFieldDef : fieldDefinitions) {
                fields.add(nxFieldDef.getFieldName());
            }
        }
        return fields;
    }

    @Override
    public void addPortalViewId(String viewId) {
        if (StringUtils.isNotBlank((String)viewId) && !this.portalViewIds.contains(viewId)) {
            this.portalViewIds.add(viewId);
        }
    }

    @Override
    public void addPortalViewsIds(String ... viewIds) {
        Object[] ids;
        if (viewIds != null && ArrayUtils.isNotEmpty((Object[])(ids = viewIds))) {
            for (String viewId : viewIds) {
                this.addPortalViewId(viewId);
            }
        }
    }

    protected static enum DefaultPortalViewId {
        toutatice_edit,
        toutatice_create,
        osivia_edit_document,
        osivia_create_document;

    }
}

