/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.services.infos.provider.DocumentInformationsProviderService;
import fr.toutatice.ecm.platform.service.url.WebIdResolver;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.primitives.BooleanProperty;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.FetchPublicationInfos", category="Fetch", label="Fetch publish space informations", description="Fetch informations about the publish space, worksapce, proxy status, ... of a given document.")
public class FetchPublicationInfos {
    private static final Log log = LogFactory.getLog(FetchPublicationInfos.class);
    public static final String ID = "Document.FetchPublicationInfos";
    public static final int ERROR_CONTENT_NOT_FOUND = 1;
    public static final int ERROR_CONTENT_FORBIDDEN = 2;
    public static final int ERROR_PUBLISH_SPACE_NOT_FOUND = 3;
    public static final int ERROR_PUBLISH_SPACE_FORBIDDEN = 4;
    public static final int ERROR_WORKSPACE_NOT_FOUND = 5;
    public static final int ERROR_WORKSPACE_FORBIDDEN = 6;
    public static final int SERVER_ERROR = 500;
    public static final String INTERNAL_PROCESSING_ERROR_RESPONSE = "InternalProcessingErrorResponse";
    private static final String TOUTATICE_PUBLI_SUFFIX = ".proxy";
    private static final String SUFFIXE_PROXY = ".proxy";
    private static final String IN_CONTEXTUALIZATON_PROPERTY = "ttc:contextualizeInternalContents";
    @Context
    protected CoreSession coreSession;
    @Context
    protected TypeManager typeService;
    @Context
    protected UserManager userManager;
    @Param(name="path", required=false)
    protected DocumentModel document;
    @Param(name="webid", required=false)
    protected String webid;

    @OperationMethod
    public Object run() throws Exception {
        Serializable commentsForbidden;
        boolean userNotAnonymous;
        DocumentRef docRef;
        Object fetchDocumentRes;
        long begin = System.currentTimeMillis();
        if (log.isTraceEnabled()) {
            String id = this.document == null ? this.webid : this.document.getPathAsString();
            log.trace((Object)(" ID: " + id));
        }
        JSONArray rowInfosPubli = new JSONArray();
        JSONObject infosPubli = new JSONObject();
        List<Integer> errorsCodes = new ArrayList<Integer>();
        if (StringUtils.isNotBlank((String)this.webid)) {
            Object documentByWebIdRes = this.getDocumentByWebId(this.webid);
            if (FetchPublicationInfos.isError(documentByWebIdRes)) {
                errorsCodes.add((Integer)documentByWebIdRes);
                infosPubli.element("errorCodes", errorsCodes);
                rowInfosPubli.add((Object)infosPubli);
                return this.createBlob(rowInfosPubli);
            }
            this.document = (DocumentModel)documentByWebIdRes;
        }
        if (FetchPublicationInfos.isError(fetchDocumentRes = this.getDocument(docRef = this.document.getRef()))) {
            errorsCodes.add((Integer)fetchDocumentRes);
            infosPubli.element("errorCodes", errorsCodes);
            rowInfosPubli.add((Object)infosPubli);
            return this.createBlob(rowInfosPubli);
        }
        DocumentModel document = (DocumentModel)fetchDocumentRes;
        boolean isVersion = document.isVersion();
        infosPubli.element("isVersion", isVersion);
        Object liveDocRes = this.getLiveDoc(this.coreSession, document, infosPubli);
        if (FetchPublicationInfos.isError(liveDocRes)) {
            infosPubli = (JSONObject)liveDocRes;
            infosPubli.element("documentPath", (Object)URLEncoder.encode(document.getPath().toString(), "UTF-8"));
            infosPubli.element("liveId", (Object)"");
            infosPubli.element("editableByUser", (Object)Boolean.FALSE);
            infosPubli.element("isDeletableByUser", (Object)Boolean.FALSE);
        } else {
            String docPath;
            DocumentModel liveDoc = (DocumentModel)liveDocRes;
            infosPubli.element("liveId", (Object)liveDoc.getId());
            Object isEditable = this.isEditableByUser(infosPubli, liveDoc);
            infosPubli.element("editableByUser", isEditable);
            Object isManageable = this.isManageableByUser(infosPubli, liveDoc);
            infosPubli.element("manageableByUser", isManageable);
            Object isDeletable = this.isDeletableByUser(infosPubli, liveDoc);
            infosPubli.element("isDeletableByUser", isDeletable);
            Boolean canUserValidate = this.canUserValidate();
            infosPubli.element("canUserValidate", (Object)canUserValidate);
            String livePath = liveDoc.getPathAsString();
            String path = docPath = document.getPath().toString();
            if (docPath.endsWith(".proxy") && docPath.equals(livePath + ".proxy")) {
                path = livePath;
            }
            infosPubli.element("documentPath", (Object)URLEncoder.encode(path, "UTF-8"));
            liveDoc = (DocumentModel)liveDocRes;
            infosPubli.element("liveVersion", (Object)liveDoc.getVersionLabel());
            DocumentInformationsProviderService fetchInfosService = (DocumentInformationsProviderService)Framework.getService(DocumentInformationsProviderService.class);
            if (fetchInfosService != null) {
                Map infosSynchro = fetchInfosService.fetchAllInfos(this.coreSession, liveDoc);
                infosPubli.accumulateAll(infosSynchro);
            }
        }
        infosPubli.put((Object)"subTypes", (Object)new JSONObject());
        if (document.isFolder()) {
            infosPubli.put((Object)"subTypes", (Object)this.getSubTypes(this.coreSession, document));
        }
        boolean docCommentable = document.hasFacet("Commentable");
        Principal user = this.coreSession.getPrincipal();
        if (user == null) {
            throw new ClientException("Current user not found.");
        }
        boolean bl = userNotAnonymous = !((NuxeoPrincipal)user).isAnonymous();
        if (document.hasSchema("toutatice") && docCommentable && (commentsForbidden = document.getPropertyValue("ttc:commentsForbidden")) != null && ((Boolean)commentsForbidden).booleanValue()) {
            docCommentable = false;
        }
        infosPubli.put((Object)"isCommentableByUser", (Object)(docCommentable && userNotAnonymous ? 1 : 0));
        if (log.isTraceEnabled()) {
            log.trace((Object)(" [Before UnrestrictedFecthPubliInfosRunner]: " + String.valueOf(System.currentTimeMillis() - begin)));
        }
        UnrestrictedFecthPubliInfosRunner infosPubliRunner = new UnrestrictedFecthPubliInfosRunner(this.coreSession, document, liveDocRes, infosPubli, this.userManager, errorsCodes);
        infosPubliRunner.runUnrestricted();
        errorsCodes = infosPubliRunner.getErrorsCodes();
        infosPubli = infosPubliRunner.getInfosPubli();
        infosPubli.element("errorCodes", errorsCodes);
        rowInfosPubli.add((Object)infosPubli);
        if (log.isTraceEnabled()) {
            long end = System.currentTimeMillis();
            log.trace((Object)(" Ended: " + String.valueOf(end - begin) + " ms ======= \r\n"));
        }
        return this.createBlob(rowInfosPubli);
    }

    public JSONObject getSubTypes(CoreSession session, DocumentModel folder) throws UnsupportedEncodingException {
        JSONObject subTypes = new JSONObject();
        boolean canAddChildren = session.hasPermission(folder.getRef(), "AddChildren");
        if (canAddChildren) {
            Collection allowedSubTypes = this.typeService.getAllowedSubTypes(folder.getType());
            for (Type subType : allowedSubTypes) {
                subTypes.put((Object)subType.getId(), (Object)URLEncoder.encode(subType.getLabel(), "UTF-8"));
            }
        }
        return subTypes;
    }

    private static int getErrorCode(Exception inputException, int errorCodeNotFound, int errorCodeForbidden) {
        Exception exception = inputException;
        int errorCode = 0;
        if (exception instanceof NoSuchDocumentException) {
            errorCode = errorCodeNotFound;
        } else if (exception instanceof DocumentSecurityException) {
            errorCode = errorCodeForbidden;
        }
        return errorCode;
    }

    private Object isEditableByUser(JSONObject infos, DocumentModel liveDoc) throws ServeurException {
        Boolean canModify = null;
        try {
            canModify = this.coreSession.hasPermission(liveDoc.getRef(), "Write");
        }
        catch (ClientException e) {
            if (e instanceof DocumentSecurityException) {
                return Boolean.FALSE;
            }
            log.warn((Object)("Failed to fetch permissions for document '" + liveDoc.getPathAsString() + "', error:" + e.getMessage()));
            throw new ServeurException((Exception)((Object)e));
        }
        return canModify;
    }

    private Object isManageableByUser(JSONObject infos, DocumentModel liveDoc) throws ServeurException {
        Boolean canManage = null;
        try {
            canManage = this.coreSession.hasPermission(liveDoc.getRef(), "Everything");
        }
        catch (ClientException e) {
            if (e instanceof DocumentSecurityException) {
                return Boolean.FALSE;
            }
            log.warn((Object)("Failed to fetch permissions for document '" + liveDoc.getPathAsString() + "', error:" + e.getMessage()));
            throw new ServeurException((Exception)((Object)e));
        }
        return canManage;
    }

    private Boolean canUserValidate() throws ServeurException, ClientException {
        return this.checkValidatePermission();
    }

    private Boolean checkValidatePermission() throws ServeurException {
        Boolean canValidate = Boolean.FALSE;
        try {
            canValidate = this.coreSession.hasPermission(this.document.getRef(), "validationWorkflow_validation");
        }
        catch (ClientException e) {
            if (e instanceof DocumentSecurityException) {
                return Boolean.FALSE;
            }
            log.warn((Object)("Failed to fetch permissions for document '" + this.document.getPathAsString() + "', error:" + e.getMessage()));
            throw new ServeurException((Exception)((Object)e));
        }
        return canValidate;
    }

    private Object isDeletableByUser(JSONObject infos, DocumentModel liveDoc) throws Exception {
        Boolean canBeDelete = Boolean.FALSE;
        try {
            TrashService trash = (TrashService)Framework.getService(TrashService.class);
            ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
            docs.add(liveDoc);
            canBeDelete = trash.canDelete(docs, this.coreSession.getPrincipal(), false);
            if (canBeDelete.booleanValue()) {
                boolean hasProxy;
                DocumentModel proxy = ToutaticeDocumentHelper.getProxy((CoreSession)this.coreSession, (DocumentModel)liveDoc, null);
                boolean bl = hasProxy = null != proxy;
                if (hasProxy) {
                    boolean canValidate = this.coreSession.hasPermission(liveDoc.getRef(), "validationWorkflow_validation");
                    canBeDelete = canValidate;
                }
            }
        }
        catch (ClientException e) {
            if (e instanceof DocumentSecurityException) {
                return Boolean.FALSE;
            }
            log.warn((Object)("Failed to fetch permissions for document '" + liveDoc.getPathAsString() + "', error:" + e.getMessage()));
            throw new ServeurException((Exception)((Object)e));
        }
        return canBeDelete;
    }

    private Object getLiveDoc(CoreSession session, DocumentModel doc, JSONObject infos) throws ServeurException {
        DocumentModel liveDoc = null;
        try {
            DocumentModel srcDocument = session.getSourceDocument(doc.getRef());
            if (session.hasPermission(srcDocument.getRef(), "ReadVersion")) {
                liveDoc = session.getWorkingCopy(srcDocument.getRef());
            }
        }
        catch (ClientException ce) {
            if (ce instanceof DocumentSecurityException) {
                infos.element("editableByUser", (Object)Boolean.FALSE);
                return infos;
            }
            log.warn((Object)("Failed to fetch live document of document'" + doc.getPathAsString() + "', error:" + ce.getMessage()));
            throw new ServeurException((Exception)((Object)ce));
        }
        if (liveDoc == null) {
            infos.element("editableByUser", (Object)Boolean.FALSE);
            return infos;
        }
        return liveDoc;
    }

    private Object getDocument(DocumentRef refDoc) throws ServeurException {
        DocumentModel doc = null;
        try {
            doc = this.coreSession.getDocument(refDoc);
        }
        catch (ClientException ce) {
            if (ce instanceof DocumentSecurityException) {
                return 2;
            }
            if (this.isNoSuchDocumentException(ce)) {
                return 1;
            }
            log.warn((Object)("Failed to fetch document with path or uid: '" + this.document + "', error:" + ce.getMessage()));
            throw new ServeurException((Exception)((Object)ce));
        }
        if (doc == null) {
            return 1;
        }
        return doc;
    }

    private Object getDocumentByWebId(String webid) {
        long begin = System.currentTimeMillis();
        DocumentModel doc = null;
        try {
            DocumentModelList documentsByWebId = WebIdResolver.getDocumentsByWebId((CoreSession)this.coreSession, (String)webid);
            if (CollectionUtils.isNotEmpty((Collection)documentsByWebId) && documentsByWebId.size() == 1) {
                doc = (DocumentModel)documentsByWebId.get(0);
            }
        }
        catch (NoSuchDocumentException e) {
            return 1;
        }
        if (log.isTraceEnabled()) {
            long end = System.currentTimeMillis();
            log.trace((Object)("      [getDocumentByWebId]: " + String.valueOf(end - begin) + " ms"));
        }
        return doc;
    }

    private boolean isNoSuchDocumentException(ClientException ce) {
        Throwable causeExc = ce.getCause();
        return causeExc instanceof NoSuchDocumentException;
    }

    private Blob createBlob(JSONArray json) {
        return new StringBlob(json.toString(), "application/json");
    }

    public static String computeNavPath(String path) {
        String result = path;
        if (path.endsWith(".proxy")) {
            result = result.substring(0, result.length() - ".proxy".length());
        }
        return result;
    }

    private static boolean isError(Object operationRes) {
        return !(operationRes instanceof DocumentModel) && !(operationRes instanceof Boolean);
    }

    private static String safeString(String value) {
        String safeValue = value;
        if (value == null) {
            safeValue = "";
        }
        return safeValue;
    }

    private static class UnrestrictedFecthPubliInfosRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel document;
        private Object liveDocRes;
        private JSONObject infosPubli;
        private List<Integer> errorsCodes;
        private UserManager userManager;

        public JSONObject getInfosPubli() {
            return this.infosPubli;
        }

        public List<Integer> getErrorsCodes() {
            return this.errorsCodes;
        }

        public UnrestrictedFecthPubliInfosRunner(CoreSession session, DocumentModel document, Object liveDocRes, JSONObject infosPubli, UserManager userManager, List<Integer> errorsCodes) {
            super(session);
            this.document = document;
            this.liveDocRes = liveDocRes;
            this.infosPubli = infosPubli;
            this.errorsCodes = errorsCodes;
            this.userManager = userManager;
        }

        public void run() throws ClientException {
            try {
                if (!FetchPublicationInfos.isError(this.liveDocRes)) {
                    DocumentModel liveDoc = (DocumentModel)this.liveDocRes;
                    this.infosPubli.put((Object)"spaceID", (Object)this.getSpaceID(liveDoc));
                    String parentSpaceID = "";
                    DocumentModelList spaceParentList = ToutaticeDocumentHelper.getParentSpaceList((CoreSession)this.session, (DocumentModel)liveDoc, (boolean)true, (boolean)true);
                    if (spaceParentList != null && spaceParentList.size() > 0) {
                        DocumentModel parentSpace = (DocumentModel)spaceParentList.get(0);
                        parentSpaceID = this.getSpaceID(parentSpace);
                    }
                    this.infosPubli.put((Object)"parentSpaceID", (Object)parentSpaceID);
                }
                AutomationService automation = null;
                try {
                    automation = (AutomationService)Framework.getService(AutomationService.class);
                }
                catch (Exception e) {
                    log.warn((Object)("Error getting automation service, error: " + e.getMessage()));
                    throw new ServeurException(e);
                }
                OperationContext ctx = new OperationContext(this.session);
                HashMap<String, DocumentModel> parameters = new HashMap<String, DocumentModel>();
                parameters.put("value", this.document);
                Object fetchPublishSpaceRes = null;
                try {
                    fetchPublishSpaceRes = ToutaticeDocumentHelper.callOperation((AutomationService)automation, (OperationContext)ctx, (String)"Document.FetchPublishSpace", parameters);
                    DocumentModel publishSpaceDoc = (DocumentModel)fetchPublishSpaceRes;
                    this.infosPubli.element("publishSpaceType", (Object)publishSpaceDoc.getType());
                    this.infosPubli.element("publishSpacePath", (Object)URLEncoder.encode(FetchPublicationInfos.computeNavPath(publishSpaceDoc.getPathAsString()), "UTF-8"));
                    try {
                        this.infosPubli.element("publishSpaceDisplayName", (Object)URLEncoder.encode(publishSpaceDoc.getTitle(), "UTF-8"));
                        BooleanProperty property = this.getInContextualizationProperty(publishSpaceDoc);
                        this.infosPubli.element("publishSpaceInContextualization", (Object)property.getValue());
                    }
                    catch (ClientException e) {
                        this.infosPubli.element("publishSpaceInContextualization", (Object)Boolean.FALSE);
                        this.errorsCodes = this.manageException(this.errorsCodes, publishSpaceDoc, e, 4, "fetch publish space name or contextualization property for space ");
                    }
                }
                catch (Exception e) {
                    this.errorsCodes.add(FetchPublicationInfos.getErrorCode(e, 3, 4));
                    this.infosPubli.element("publishSpaceInContextualization", (Object)Boolean.FALSE);
                    this.infosPubli.element("publishSpaceType", (Object)"");
                    this.infosPubli.element("publishSpacePath", (Object)"");
                    this.infosPubli.element("publishSpaceDisplayName", (Object)"");
                }
                parameters.clear();
                parameters.put("document", this.document);
                Object workspaceRes = null;
                try {
                    workspaceRes = ToutaticeDocumentHelper.callOperation((AutomationService)automation, (OperationContext)ctx, (String)"Document.FetchWorkspaceOfDocument", parameters);
                    DocumentModel workspace = (DocumentModel)workspaceRes;
                    this.infosPubli.element("workspacePath", (Object)URLEncoder.encode(workspace.getPathAsString(), "UTF-8"));
                    try {
                        this.infosPubli.element("workspaceDisplayName", (Object)URLEncoder.encode(workspace.getTitle(), "UTF-8"));
                    }
                    catch (ClientException e) {
                        this.errorsCodes = this.manageException(this.errorsCodes, workspace, e, 6, "fetch workspace name or contextualization property for workspace");
                    }
                }
                catch (Exception e) {
                    this.infosPubli.element("workspaceInContextualization", (Object)Boolean.FALSE);
                    this.infosPubli.element("workspacePath", (Object)"");
                    this.infosPubli.element("workspaceDisplayName", (Object)"");
                    this.errorsCodes.add(FetchPublicationInfos.getErrorCode(e, 5, 6));
                }
                this.infosPubli.element("workspaceInContextualization", (Object)Boolean.TRUE);
                if (!FetchPublicationInfos.isError(this.liveDocRes)) {
                    DocumentModel liveDoc = (DocumentModel)this.liveDocRes;
                    Boolean isRemotePublishable = this.isRemotePublishable(liveDoc, workspaceRes);
                    this.infosPubli.put((Object)"isRemotePublishable", (Object)isRemotePublishable);
                    if (isRemotePublishable.booleanValue()) {
                        Boolean isRemotePublished = this.isRemotePublished(liveDoc);
                        this.infosPubli.put((Object)"isRemotePublished", (Object)isRemotePublished);
                    } else {
                        this.infosPubli.put((Object)"isRemotePublished", (Object)Boolean.FALSE);
                    }
                }
                DocumentModel publishedDoc = null;
                try {
                    publishedDoc = ToutaticeDocumentHelper.getProxy((CoreSession)this.session, (DocumentModel)this.document, (String)"Read");
                    Boolean isBeingModified = Boolean.FALSE;
                    if (publishedDoc != null) {
                        isBeingModified = !publishedDoc.getVersionLabel().equals(this.infosPubli.get("liveVersion"));
                    } else {
                        String publishSpacePath = URLDecoder.decode(this.infosPubli.getString("publishSpacePath"), "UTF-8");
                        if (StringUtils.isNotEmpty((String)publishSpacePath)) {
                            isBeingModified = Boolean.TRUE;
                        }
                    }
                    this.infosPubli.element("isLiveModifiedFromProxy", (Object)isBeingModified);
                    this.infosPubli.element("proxyVersion", (Object)(publishedDoc != null ? publishedDoc.getVersionLabel() : "0.0"));
                    this.infosPubli.element("published", (Object)(publishedDoc != null ? Boolean.TRUE : Boolean.FALSE));
                }
                catch (Exception e) {
                    this.infosPubli.element("isLiveModifiedFromProxy", (Object)Boolean.TRUE);
                    this.infosPubli.element("published", (Object)Boolean.FALSE);
                }
                Object isAnonymousRes = this.isAnonymous(this.session, this.userManager, this.document, this.infosPubli);
                if (FetchPublicationInfos.isError(isAnonymousRes)) {
                    this.infosPubli = (JSONObject)isAnonymousRes;
                } else {
                    this.infosPubli.element("anonymouslyReadable", isAnonymousRes);
                }
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }

        private Boolean isRemotePublishable(DocumentModel liveDoc, Object workspaceRes) {
            boolean is = false;
            if (workspaceRes instanceof DocumentModel) {
                is = !liveDoc.isFolder() && liveDoc.hasFacet("Publishable") && !liveDoc.isImmutable();
            }
            return is;
        }

        private boolean isRemotePublished(DocumentModel liveDoc) {
            DocumentModelList remotePublishedDocuments = ToutaticeDocumentHelper.getRemotePublishedDocuments((CoreSession)this.session, (DocumentModel)liveDoc);
            return remotePublishedDocuments.size() > 0;
        }

        private Boolean isLiveModifiedFromProxies(DocumentModel liveDoc) {
            Boolean isModified = Boolean.TRUE;
            PublisherService publisherService = (PublisherService)Framework.getService(PublisherService.class);
            Map availablePublicationTrees = publisherService.getAvailablePublicationTrees();
            if (MapUtils.isNotEmpty((Map)availablePublicationTrees)) {
                for (Map.Entry treeInfo : availablePublicationTrees.entrySet()) {
                    String treeName = (String)treeInfo.getKey();
                    PublicationTree tree = publisherService.getPublicationTree(treeName, this.session, null);
                    List publishedDocuments = tree.getExistingPublishedDocument((DocumentLocation)new DocumentLocationImpl(this.document));
                    for (PublishedDocument publishedDoc : publishedDocuments) {
                        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDoc).getProxy();
                        if (!liveDoc.getVersionLabel().equals(proxy.getVersionLabel())) continue;
                        isModified = isModified & Boolean.FALSE;
                    }
                }
            }
            return isModified;
        }

        private Object isAnonymous(CoreSession session, UserManager userManager, DocumentModel doc, JSONObject infos) throws ServeurException {
            boolean isAnonymous = false;
            try {
                ACP acp = this.document.getACP();
                String anonymousId = userManager.getAnonymousUserId();
                Access access = acp.getAccess(anonymousId, "Read");
                isAnonymous = access.toBoolean();
            }
            catch (ClientException e) {
                if (e instanceof DocumentSecurityException) {
                    infos.element("anonymouslyReadable", (Object)Boolean.FALSE);
                    return infos;
                }
                log.warn((Object)("Failed to get ACP of document '" + doc.getPathAsString() + "', error:" + e.getMessage()));
                throw new ServeurException((Exception)((Object)e));
            }
            return isAnonymous;
        }

        private BooleanProperty getInContextualizationProperty(DocumentModel doc) throws PropertyException, ClientException {
            BooleanProperty property = (BooleanProperty)doc.getProperty(FetchPublicationInfos.IN_CONTEXTUALIZATON_PROPERTY);
            return property;
        }

        private List<Integer> manageException(List<Integer> errorsCodes, DocumentModel doc, ClientException ce, int errorCode, String msg) throws ServeurException {
            if (!(ce instanceof DocumentSecurityException)) {
                log.warn((Object)("Failed" + msg + "'" + doc.getPathAsString() + "', error:" + ce.getMessage()));
                throw new ServeurException((Exception)((Object)ce));
            }
            errorsCodes.add(errorCode);
            return errorsCodes;
        }

        private String getSpaceID(DocumentModel document) {
            String spaceID = "";
            try {
                spaceID = ToutaticeDocumentHelper.isASpaceDocument((DocumentModel)document) ? document.getId() : FetchPublicationInfos.safeString((String)document.getProperty("toutatice", "spaceID"));
            }
            catch (ClientException e) {
                log.error((Object)("Failed to read the ttc:spaceID meta-data, error:" + e.getMessage()));
            }
            return spaceID;
        }
    }

    public static class ServeurException
    extends Exception {
        private static final long serialVersionUID = -2490817493963408580L;

        ServeurException() {
        }

        ServeurException(Exception e) {
            super(e);
        }
    }
}

