/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.service.fragments.configuration.ConfigurationBeanHelper;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.jsf.OperationHelper;
import org.nuxeo.ecm.automation.seam.operations.SeamOperationFilter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

@Operation(id="Context.GetWebConfigurations", category="Services", label="Gets global and local web configurations", description="Gets global and local web configuration.")
public class GetWebConfigurations {
    public static final String ID = "Context.GetWebConfigurations";
    public static final String CONVERSATION_ID = "0NXMAIN0";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession coreSession;
    @Param(name="domainPath")
    protected String domainPath;
    @Param(name="confType")
    protected String confType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public DocumentModelList run() throws Exception {
        if (!OperationHelper.isSeamContextAvailable()) {
            SeamOperationFilter.handleBeforeRun((OperationContext)this.ctx, (String)CONVERSATION_ID);
            try {
                DocumentModelList documentModelList = this.getConfigs();
                return documentModelList;
            }
            finally {
                SeamOperationFilter.handleAfterRun((OperationContext)this.ctx, (String)CONVERSATION_ID);
            }
        }
        return this.getConfigs();
    }

    private DocumentModelList getConfigs() {
        ConfigurationBeanHelper configHelper = ConfigurationBeanHelper.getBean();
        DocumentModel domain = this.coreSession.getDocument((DocumentRef)new PathRef(this.domainPath));
        return configHelper.getConfigs(this.confType, this.coreSession, domain);
    }
}

