/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.blob;

import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;

@Operation(id="Blob.AnyToPDF")
public class AnyBlobToPDF {
    private static final Log log = LogFactory.getLog(AnyBlobToPDF.class);
    public static final String ID = "Blob.AnyToPDF";
    @Context
    protected ConversionService service;
    @Param(name="converterName", required=false)
    protected String converterName = "toutaticeAny2pdf";

    @OperationMethod
    public Blob run(DocumentModel doc) throws Exception {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        if ("application/pdf".equals(bh.getBlob().getMimeType())) {
            return bh.getBlob();
        }
        Blob result = null;
        GregorianCalendar modDate = (GregorianCalendar)doc.getPropertyValue("dc:modified");
        HashMap<String, Long> cacheKeyParams = new HashMap<String, Long>();
        cacheKeyParams.put("modifiedOn", modDate.getTimeInMillis());
        BlobHolder pdfBh = this.service.convert(this.converterName, bh, cacheKeyParams);
        result = pdfBh.getBlob();
        String fname = result.getFilename();
        String filename = bh.getBlob().getFilename();
        if (filename != null && !filename.isEmpty()) {
            int pos = filename.lastIndexOf(46);
            if (pos > 0) {
                filename = filename.substring(0, pos);
            }
            filename = filename + ".pdf";
            result.setFilename(filename);
        } else if (fname != null && !fname.isEmpty()) {
            result.setFilename(fname);
        } else {
            result.setFilename("file");
        }
        result.setMimeType("application/pdf");
        return result;
    }
}

