/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpNotificationForwarder;
import com.sun.jdmk.comm.GenericHttpRequestHandler;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HeartBeatServerHandler;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.comm.ServerNotificationDispatcher;
import com.sun.jdmk.comm.ServerNotificationHandlerInternal;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class GenericHttpConnectorServer
extends CommunicatorServer {
    transient GenericHttpSocket sockListen = null;
    InetAddress addrLastClient = null;
    Vector authInfo = new Vector();
    int index = 0;
    final int MAX_CHALLENGES = 100;
    String[] challengeList = new String[100];
    ServerNotificationDispatcher serverNotificationDispatcher = null;
    HeartBeatServerHandler heartbeatServerHandler = null;
    InetAddress bindAddr = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    abstract GenericHttpSocket createSocket();

    abstract GenericHttpNotificationForwarder getNotificationForwarder(GenericHttpConnectorAddress var1);

    public GenericHttpConnectorServer(int connectorType) throws IllegalArgumentException {
        super(connectorType);
        this.maxActiveClientCount = 10;
    }

    public GenericHttpConnectorServer(int connectorType, int port) throws IllegalArgumentException {
        this(connectorType);
        this.port = port;
    }

    public GenericHttpConnectorServer(int connectorType, int port, AuthInfo[] authInfoList) throws IllegalArgumentException {
        this(connectorType, port);
        if (authInfoList != null) {
            int i = 0;
            while (i < authInfoList.length) {
                this.addUserAuthenticationInfo(authInfoList[i]);
                ++i;
            }
        }
    }

    public GenericHttpConnectorServer(int connectorType, int port, InetAddress bindAddr) throws IllegalArgumentException {
        this(connectorType);
        this.port = port;
        this.bindAddr = bindAddr;
    }

    public GenericHttpConnectorServer(int connectorType, int port, AuthInfo[] authInfoList, InetAddress bindAddr) throws IllegalArgumentException {
        this(connectorType, port, bindAddr);
        if (authInfoList != null) {
            int i = 0;
            while (i < authInfoList.length) {
                this.addUserAuthenticationInfo(authInfoList[i]);
                ++i;
            }
        }
    }

    NotificationBackConnector startPush(ConnectorAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException("ConnectorAddress cannot be null");
        }
        if (!(addr instanceof GenericHttpConnectorAddress)) {
            throw new IllegalArgumentException("ConnectorAddress must be an instance of GenericHttpConnectorAddress");
        }
        GenericHttpNotificationForwarder notificationForwarder = null;
        try {
            if (this.logger.finestOn()) {
                this.logger.finest("startPush", "Create new NotificationForwarder");
            }
            notificationForwarder = this.getNotificationForwarder((GenericHttpConnectorAddress)addr);
        }
        catch (CommunicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
        if (this.logger.finestOn()) {
            this.logger.finest("startPush", "Start forwarding events");
        }
        notificationForwarder.connect();
        return notificationForwarder;
    }

    void stopPush(NotificationBackConnector connector) {
        if (!(connector instanceof GenericHttpNotificationForwarder)) {
            throw new IllegalArgumentException("NotificationBackConnector must be an instance of GenericHttpNotificationForwarder");
        }
        ((GenericHttpNotificationForwarder)connector).disconnect();
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return super.preRegister(server, name);
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        NotificationHandlerInternal handler = new NotificationHandlerInternal(this);
        this.serverNotificationDispatcher = new ServerNotificationDispatcher(handler, this.topMBS);
        this.heartbeatServerHandler = new HeartBeatServerHandler(this.topMBS, this.serverNotificationDispatcher);
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    @Override
    public void postDeregister() {
        super.postDeregister();
    }

    @Override
    protected void doError(Exception e) throws CommunicationException {
    }

    @Override
    protected void doBind() throws InterruptedException, CommunicationException {
        try {
            if (this.bindAddr == null) {
                if (this.logger.finerOn()) {
                    this.logger.finer("doBind", "about to bind to port " + this.port);
                }
                this.sockListen = this.createSocket().createServerSocket(this.port);
            } else {
                if (this.logger.finerOn()) {
                    this.logger.finer("doBind", "about to bind to address:port " + this.bindAddr + ":" + this.port);
                }
                this.sockListen = this.createSocket().createServerSocket(this.port, this.bindAddr);
            }
            this.sockListen.doBind();
            this.port = this.sockListen.getLocalPort();
            this.dbgTag = this.makeDebugTag();
            if (this.logger.finerOn()) {
                this.logger.finer("doBind", String.valueOf(this.sockListen.toString()) + " bound to " + this.sockListen.getLocalAddress() + " port " + this.sockListen.getLocalPort());
            }
        }
        catch (SocketException e) {
            if (this.logger.finerOn()) {
                this.logger.finer("doBind", "EXCEPTION MSG = '" + e.getMessage() + "'");
            }
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            throw new CommunicationException(e);
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    protected void doReceive() throws InterruptedException, CommunicationException {
        try {
            this.sockListen.doReceive();
            this.addrLastClient = this.sockListen.getRemoteAddress();
        }
        catch (SocketException e) {
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            throw new CommunicationException(e);
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (IOException e) {
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            throw new CommunicationException(e);
        }
        catch (CommunicationException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.logger.finerOn()) {
                this.logger.finer("doReceive", "EXCEPTION MSG = '" + e.getMessage() + "'");
            }
            throw new InterruptedException();
        }
    }

    @Override
    protected void doProcess() throws InterruptedException, CommunicationException {
        if (this.logger.finerOn()) {
            this.logger.finer("doProcess", "Address of last connected client [" + this.addrLastClient + "]");
        }
        GenericHttpRequestHandler server = new GenericHttpRequestHandler(this, this.getServedClientCount(), (GenericHttpSocket)this.sockListen.clone(), this.topMBS, this.objectName);
    }

    @Override
    protected void doUnbind() throws InterruptedException, CommunicationException {
        try {
            if (this.sockListen != null) {
                if (this.logger.finerOn()) {
                    this.logger.finer("doUnbind", "Port [" + this.port + "] has been definitively closed");
                }
                this.sockListen.doUnbind();
            }
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    String makeDebugTag() {
        return "GenericHttpConnectorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    @Override
    public void stop() {
        if (this.state == 0 || this.state == 3) {
            super.stop();
            this.heartbeatServerHandler.cleanupClientResources();
            try {
                GenericHttpSocket sn = this.sockListen.createClientSocket();
                if (System.getProperty("jdmk.hostname") != null) {
                    sn.doConnect(System.getProperty("jdmk.hostname"), this.port);
                } else {
                    sn.doConnect(InetAddress.getLocalHost().getHostAddress(), this.port);
                }
                sn.doSend("", null);
                sn.doDisconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void setMBeanServer(MBeanServer newMBS) throws IllegalArgumentException, IllegalStateException {
        super.setMBeanServer(newMBS);
        this.serverNotificationDispatcher.setMBeanServer(newMBS);
    }

    @Override
    public int getServedClientCount() {
        return super.getServedClientCount();
    }

    @Override
    public int getActiveClientCount() {
        return super.getActiveClientCount();
    }

    @Override
    public int getMaxActiveClientCount() {
        return super.getMaxActiveClientCount();
    }

    @Override
    public void setMaxActiveClientCount(int c) throws IllegalStateException {
        super.setMaxActiveClientCount(c);
    }

    public String getLastConnectedClient() {
        if (this.addrLastClient == null) {
            return "unknown";
        }
        return this.addrLastClient.toString();
    }

    public synchronized void addUserAuthenticationInfo(AuthInfo authinfo) {
        if (authinfo != null) {
            String username = authinfo.getLogin();
            Enumeration e = this.authInfo.elements();
            while (e.hasMoreElements()) {
                AuthInfo ai = (AuthInfo)e.nextElement();
                if (!ai.getLogin().equals(username)) continue;
                this.authInfo.removeElement(ai);
                break;
            }
            this.authInfo.addElement(authinfo);
        }
    }

    public synchronized void removeUserAuthenticationInfo(AuthInfo authinfo) {
        if (authinfo != null) {
            String username = authinfo.getLogin();
            Enumeration e = this.authInfo.elements();
            while (e.hasMoreElements()) {
                AuthInfo ai = (AuthInfo)e.nextElement();
                if (!ai.getLogin().equals(username)) continue;
                this.authInfo.removeElement(ai);
                break;
            }
        }
    }

    public boolean isAuthenticationOn() {
        return !this.authInfo.isEmpty();
    }

    synchronized String generateChallengeResponse() {
        String hostname = null;
        try {
            if (System.getProperty("jdmk.hostname") != null) {
                hostname = System.getProperty("jdmk.hostname");
            } else {
                InetAddress localhost = InetAddress.getLocalHost();
                hostname = localhost.getHostName();
            }
            if (this.logger.finerOn()) {
                this.logger.finer("generateChallengeResponse", "hostname=" + hostname);
            }
        }
        catch (UnknownHostException e) {
            hostname = "UnknownHost";
        }
        String challenge = "<" + System.currentTimeMillis() + "@" + hostname + ">";
        if (this.index == 100) {
            this.index = 0;
        }
        this.challengeList[this.index] = challenge;
        ++this.index;
        return challenge;
    }

    synchronized AuthInfo checkChallengeResponse(String response) {
        if (response == null) {
            return null;
        }
        String username = response.substring(0, response.lastIndexOf(32));
        String digest = response.substring(response.lastIndexOf(32) + 1);
        AuthInfo ai = null;
        boolean found = false;
        Enumeration e = this.authInfo.elements();
        while (e.hasMoreElements()) {
            ai = (AuthInfo)e.nextElement();
            if (!ai.getLogin().equals(username)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        byte[] keyBytes = ai.getPassword().getBytes();
        int i = 0;
        while (i < 100) {
            String hmac;
            String challenge = this.challengeList[i];
            if (challenge != null && digest.equals(hmac = this.HMAC_MD5(challenge.getBytes(), keyBytes))) {
                this.challengeList[i] = null;
                return ai;
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private String HMAC_MD5(byte[] challenge, byte[] key) {
        MD5_BLOCKSIZE = 64;
        md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException var5_5) {
            // empty catch block
        }
        if (key.length > 64) {
            key = md5.digest(key);
        }
        ipad = new byte[64];
        opad = new byte[64];
        i = 0;
        ** GOTO lbl22
        {
            ipad[i] = key[i];
            opad[i] = key[i];
            ++i;
            do {
                if (i < key.length) continue block2;
                ipad[i] = 0;
                opad[i] = 0;
                ++i;
lbl22:
                // 2 sources

            } while (i < 64);
        }
        i = 0;
        while (i < 64) {
            v0 = i;
            ipad[v0] = (byte)(ipad[v0] ^ 54);
            v1 = i++;
            opad[v1] = (byte)(opad[v1] ^ 92);
        }
        md5.update(ipad);
        md5.update(challenge);
        digest = md5.digest();
        md5.update(opad);
        md5.update(digest);
        digest = md5.digest();
        digestString = new StringBuffer();
        i = 0;
        while (i < digest.length) {
            if ((digest[i] & 255) < 16) {
                digestString.append("0" + Integer.toHexString(digest[i] & 255));
            } else {
                digestString.append(Integer.toHexString(digest[i] & 255));
            }
            ++i;
        }
        return digestString.toString();
    }

    private class NotificationHandlerInternal
    implements ServerNotificationHandlerInternal {
        private GenericHttpConnectorServer connector;

        public NotificationHandlerInternal(GenericHttpConnectorServer connector) {
            this.connector = connector;
        }

        @Override
        public NotificationBackConnector startPush(ConnectorAddress addr) {
            return this.connector.startPush(addr);
        }

        @Override
        public void stopPush(NotificationBackConnector connector) {
            this.connector.stopPush(connector);
        }
    }
}

