/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.elasticsearch.automation;

import fr.toutatice.ecm.elasticsearch.helper.SQLHelper;
import fr.toutatice.ecm.elasticsearch.query.TTCNxQueryBuilder;
import fr.toutatice.ecm.elasticsearch.search.TTCSearchResponse;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.jaxrs.DefaultJsonAdapter;
import org.nuxeo.ecm.automation.jaxrs.JsonAdapter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;

@Operation(id="Document.QueryES", category="Fetch", label="Query via ElasticSerach", description="Perform a query on ElasticSerach instead of Repository")
public class QueryES {
    private static final Log log = LogFactory.getLog(QueryES.class);
    private static final int DEFAULT_MAX_RESULT_SIZE = 10000;
    public static final String ID = "Document.QueryES";
    @Context
    CoreSession session;
    @Context
    OperationContext ctx;
    @Context
    ElasticSearchService elasticSearchService;
    @Context
    ElasticSearchAdmin elasticSearchAdmin;
    @Context
    SchemaManager schemaManager;
    @Param(name="query", required=true)
    protected String query;
    @Param(name="queryLanguage", required=false, description="Language of the query parameter : NXQL or ES.", values={"NXQL"})
    protected String queryLanguage = QueryLanguage.NXQL.name();
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Param(name="currentPageIndex", required=false)
    protected Integer currentPageIndex;
    @Deprecated
    @Param(name="page", required=false)
    protected Integer page;
    @Param(name="X-NXDocumentProperties", required=false)
    protected String nxProperties;

    @OperationMethod
    public JsonAdapter run() throws OperationException {
        try {
            switch (QueryLanguage.valueOf(this.queryLanguage)) {
                case NXQL: {
                    return this.runNxqlSearch();
                }
                case ES: {
                    return this.runEsSearch();
                }
            }
            throw new OperationException("Illegal argument value for parameter 'queryLanguage' : " + this.queryLanguage);
        }
        catch (IllegalArgumentException e) {
            throw new OperationException("Illegal argument value for parameter 'queryLanguage' : " + this.queryLanguage, (Throwable)e);
        }
    }

    @OperationMethod
    public JsonAdapter runNxqlSearch() throws OperationException {
        Integer currentPageIndex = this.currentPageIndex;
        if (this.currentPageIndex == null) {
            currentPageIndex = this.page;
        }
        NxQueryBuilder builder = new TTCNxQueryBuilder(this.session).nxql(SQLHelper.getInstance().escape(this.query));
        if (null != currentPageIndex && null != this.pageSize) {
            builder.offset((0 <= currentPageIndex ? currentPageIndex : 0) * this.pageSize);
            builder.limit(this.pageSize.intValue());
        } else {
            builder.limit(10000);
        }
        this.elasticSearchService.query(builder);
        SearchResponse esResponse = ((TTCNxQueryBuilder)builder).getSearchResponse();
        String schemas = this.nxProperties;
        if (this.nxProperties == null) {
            schemas = this.getSchemasFromHeader(this.ctx);
        }
        return new DefaultJsonAdapter((Object)new TTCSearchResponse(esResponse, this.pageSize, currentPageIndex, this.formatSchemas(schemas)));
    }

    public String getSchemasFromHeader(OperationContext ctx) {
        HttpServletRequest httpRequest = (HttpServletRequest)ctx.get((Object)"request");
        String schemas = httpRequest.getHeader("X-NXDocumentProperties");
        return !StringUtils.equals((String)"*", (String)schemas) ? schemas : null;
    }

    private List<String> formatSchemas(String nxProperties) {
        ArrayList<String> schemas = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)nxProperties)) {
            String[] schemasList;
            for (String schema : schemasList = nxProperties.split(",")) {
                Schema sch = this.schemaManager.getSchema(StringUtils.trim((String)schema));
                if (null != sch) {
                    String prefix = sch.getNamespace().prefix;
                    schemas.add(StringUtils.isNotBlank((String)prefix) ? prefix : sch.getName());
                    continue;
                }
                log.warn((Object)("Unknown schema '" + schema + "' (query='" + this.query + "')"));
            }
        }
        return schemas;
    }

    protected JsonAdapter runEsSearch() throws OperationException {
        SearchRequestBuilder request = this.elasticSearchAdmin.getClient().prepareSearch(new String[]{this.elasticSearchAdmin.getIndexNameForRepository(this.session.getRepositoryName())}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        request.setSource(this.getESRequestPayload());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Search query: curl -XGET 'http://localhost:9200/%s/_search?pretty' -d '%s'", this.elasticSearchAdmin.getIndexNameForRepository(this.session.getRepositoryName()), request.toString()));
        }
        try {
            SearchResponse esResponse = (SearchResponse)request.get();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Result: " + esResponse.toString()));
            }
            return new DefaultJsonAdapter((Object)esResponse);
        }
        catch (ElasticsearchException e) {
            throw new OperationException("Error while executing the ElasticSearch request", (Throwable)e);
        }
    }

    public String getESRequestPayload() {
        JSONObject query;
        Principal principal = this.session.getPrincipal();
        if (principal == null || principal instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAdministrator()) {
            return this.query;
        }
        String[] principals = SecurityService.getPrincipalsToCheck((Principal)principal);
        JSONObject payloadJson = JSONObject.fromObject((Object)this.query);
        if (payloadJson.has("query")) {
            query = payloadJson.getJSONObject("query");
            payloadJson.remove("query");
        } else {
            query = JSONObject.fromObject((Object)"{\"match_all\":{}}");
        }
        JSONObject filterAcl = new JSONObject().element("terms", (Map)new JSONObject().element("ecm:acl", (Object)principals));
        JSONObject newQuery = new JSONObject().element("filtered", (Map)new JSONObject().element("query", (Map)query).element("filter", (Map)filterAcl));
        payloadJson.put((Object)"query", (Object)newQuery);
        String filteredPayload = payloadJson.toString();
        return filteredPayload;
    }

    public static enum QueryLanguage {
        NXQL,
        ES;

    }
}

