/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.elasticsearch.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.elasticsearch.listener.ElasticSearchInlineListener;
import org.nuxeo.runtime.api.Framework;

public class ToSyncEsIndexingFilter
implements Filter {
    public static final String ES_INDEXING_SYNC_FORCE = "ottc.es.indexing.sync.force";
    public static final String ES_INDEXING_ASYNC_FORCE_FLAG = "nx_es_indexing_async_force";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        boolean syncEsFromConfig = Boolean.valueOf(Framework.getProperty((String)ES_INDEXING_SYNC_FORCE));
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        boolean asyncEsFromHeader = Boolean.valueOf(httpRequest.getHeader(ES_INDEXING_ASYNC_FORCE_FLAG));
        boolean syncEs = syncEsFromConfig && asyncEsFromHeader ? asyncEsFromHeader : syncEsFromConfig;
        ElasticSearchInlineListener.useSyncIndexing.set(syncEs);
        try {
            chain.doFilter(request, response);
        }
        finally {
            ElasticSearchInlineListener.useSyncIndexing.set(false);
        }
    }

    public void destroy() {
    }
}

