/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.oauth;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public abstract class DirectoryBasedEditor
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected DocumentModelList entries;
    protected DocumentModel editableEntry;
    protected DocumentModel creationEntry;
    protected boolean showAddForm = false;

    protected abstract String getDirectoryName();

    protected abstract String getSchemaName();

    public boolean getShowAddForm() {
        return this.showAddForm;
    }

    public void toggleShowAddForm() {
        this.showAddForm = !this.showAddForm;
    }

    public DocumentModel getCreationEntry() throws Exception {
        if (this.creationEntry == null) {
            this.creationEntry = BaseSession.createEntryModel(null, (String)this.getSchemaName(), null, null);
        }
        return this.creationEntry;
    }

    public void refresh() {
        this.entries = null;
    }

    public void createEntry() throws Exception {
        Framework.doPrivileged((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
                try (Session session = ds.open(DirectoryBasedEditor.this.getDirectoryName());){
                    session.createEntry(DirectoryBasedEditor.this.creationEntry);
                    DirectoryBasedEditor.this.creationEntry = null;
                    DirectoryBasedEditor.this.showAddForm = false;
                    DirectoryBasedEditor.this.entries = null;
                }
            }
        });
    }

    public void resetCreateEntry() {
        this.creationEntry = null;
        this.showAddForm = false;
    }

    public void resetEditEntry() {
        this.editableEntry = null;
        this.showAddForm = false;
    }

    public DocumentModel getEditableEntry() {
        return this.editableEntry;
    }

    protected Map<String, Serializable> getQueryFilter() {
        return Collections.emptyMap();
    }

    protected Set<String> getOrderSet() {
        return Collections.emptySet();
    }

    public DocumentModelList getEntries() throws Exception {
        Framework.doPrivileged((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (DirectoryBasedEditor.this.entries == null) {
                    DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
                    try (Session session = ds.open(DirectoryBasedEditor.this.getDirectoryName());){
                        Map<String, Serializable> emptyMap = DirectoryBasedEditor.this.getQueryFilter();
                        Set<String> emptySet = DirectoryBasedEditor.this.getOrderSet();
                        DirectoryBasedEditor.this.entries = session.query(emptyMap, emptySet, null, true);
                    }
                }
            }
        });
        return this.entries;
    }

    public void editEntry(String entryId) throws Exception {
        final String fEntryId = entryId;
        Framework.doPrivileged((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
                try (Session session = ds.open(DirectoryBasedEditor.this.getDirectoryName());){
                    DirectoryBasedEditor.this.editableEntry = session.getEntry(fEntryId);
                }
            }
        });
    }

    public void saveEntry() throws Exception {
        Framework.doPrivileged((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
                try (Session session = ds.open(DirectoryBasedEditor.this.getDirectoryName());){
                    session.updateEntry(DirectoryBasedEditor.this.editableEntry);
                    DirectoryBasedEditor.this.editableEntry = null;
                    DirectoryBasedEditor.this.entries = null;
                }
            }
        });
    }

    public void deleteEntry(String entryId) throws Exception {
        final String fEntryId = entryId;
        Framework.doPrivileged((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
                try (Session session = ds.open(DirectoryBasedEditor.this.getDirectoryName());){
                    session.deleteEntry(fEntryId);
                    if (DirectoryBasedEditor.this.editableEntry != null && DirectoryBasedEditor.this.editableEntry.getId().equals(fEntryId)) {
                        DirectoryBasedEditor.this.editableEntry = null;
                    }
                    DirectoryBasedEditor.this.entries = null;
                }
            }
        });
    }
}

