/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.base64;

import com.phloc.commons.base64.Base64;
import com.phloc.commons.charset.CharsetManager;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Base64Helper {
    private static final Base64Helper s_aInstance = new Base64Helper();

    private Base64Helper() {
    }

    @Nullable
    public static byte[] safeDecode(@Nonnull String string) {
        try {
            return Base64.decode(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static byte[] safeDecode(@Nonnull byte[] byArray) {
        try {
            return Base64.decode(byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static String safeDecodeAsString(@Nonnull String string, @Nonnull String string2) {
        try {
            return CharsetManager.getAsString(Base64.decode(string), string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static String safeDecodeAsString(@Nonnull String string, @Nonnull Charset charset) {
        try {
            return CharsetManager.getAsString(Base64.decode(string), charset);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static String safeDecodeAsString(@Nonnull byte[] byArray, @Nonnull String string) {
        try {
            return CharsetManager.getAsString(Base64.decode(byArray), string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static String safeDecodeAsString(@Nonnull byte[] byArray, @Nonnull Charset charset) {
        try {
            return CharsetManager.getAsString(Base64.decode(byArray), charset);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static String safeEncode(@Nonnull String string, @Nonnull String string2) {
        return Base64.encodeBytes(CharsetManager.getAsBytes(string, string2));
    }

    @Nullable
    public static String safeEncode(@Nonnull String string, @Nonnull Charset charset) {
        return Base64.encodeBytes(CharsetManager.getAsBytes(string, charset));
    }
}

