/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.state.impl;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IReadonlyWrapper;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.IChangeIndicator;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ChangeWithValue<DATATYPE>
implements IChangeIndicator,
IReadonlyWrapper<DATATYPE> {
    private final EChange m_eChange;
    private final DATATYPE m_aObj;

    public ChangeWithValue(@Nonnull IChangeIndicator iChangeIndicator, @Nullable DATATYPE DATATYPE) {
        if (iChangeIndicator == null) {
            throw new NullPointerException("changeIndicator");
        }
        this.m_eChange = EChange.valueOf(iChangeIndicator);
        this.m_aObj = DATATYPE;
    }

    @Override
    public boolean isChanged() {
        return this.m_eChange.isChanged();
    }

    @Override
    public boolean isUnchanged() {
        return this.m_eChange.isUnchanged();
    }

    @Override
    @Nullable
    public DATATYPE get() {
        return this.m_aObj;
    }

    @Nullable
    public DATATYPE getIfChanged(@Nullable DATATYPE DATATYPE) {
        return this.m_eChange.isChanged() ? this.m_aObj : DATATYPE;
    }

    @Nullable
    public DATATYPE getIfChangedOrNull() {
        return this.getIfChanged(null);
    }

    @Nullable
    public DATATYPE getIfUnchanged(@Nullable DATATYPE DATATYPE) {
        return this.m_eChange.isUnchanged() ? this.m_aObj : DATATYPE;
    }

    @Nullable
    public DATATYPE getIfUnchangedOrNull() {
        return this.getIfUnchanged(null);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ChangeWithValue)) {
            return false;
        }
        ChangeWithValue changeWithValue = (ChangeWithValue)object;
        return this.m_eChange.equals(changeWithValue.m_eChange) && EqualsUtils.equals(this.m_aObj, changeWithValue.m_aObj);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eChange)).append(this.m_aObj).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("change", this.m_eChange).append("obj", this.m_aObj).toString();
    }

    @Nonnull
    public static <DATATYPE> ChangeWithValue<DATATYPE> createChanged(@Nullable DATATYPE DATATYPE) {
        return new ChangeWithValue<DATATYPE>(EChange.CHANGED, DATATYPE);
    }

    @Nonnull
    public static <DATATYPE> ChangeWithValue<DATATYPE> createUnchanged(@Nullable DATATYPE DATATYPE) {
        return new ChangeWithValue<DATATYPE>(EChange.UNCHANGED, DATATYPE);
    }
}

