/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.sort;

import com.phloc.commons.hierarchy.DefaultHierarchyWalkerCallback;
import com.phloc.commons.tree.IBasicTree;
import com.phloc.commons.tree.utils.sort.ComparatorTreeItemID;
import com.phloc.commons.tree.utils.sort.ComparatorTreeItemIDComparable;
import com.phloc.commons.tree.utils.sort.ComparatorTreeItemValue;
import com.phloc.commons.tree.utils.sort.ComparatorTreeItemValueComparable;
import com.phloc.commons.tree.utils.walk.TreeWalker;
import com.phloc.commons.tree.withid.ITreeItemWithID;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeWithIDSorter {
    private static final TreeWithIDSorter s_aInstance = new TreeWithIDSorter();

    private TreeWithIDSorter() {
    }

    private static <KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> void _sort(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> iBasicTree, final @Nonnull Comparator<? super ITEMTYPE> comparator) {
        if (iBasicTree == null) {
            throw new NullPointerException("tree");
        }
        if (comparator == null) {
            throw new NullPointerException("comparator");
        }
        ((ITreeItemWithID)iBasicTree.getRootItem()).reorderChildrenByItems(comparator);
        TreeWalker.walkTree(iBasicTree, new DefaultHierarchyWalkerCallback<ITEMTYPE>(){

            @Override
            public void onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    ITEMTYPE.reorderChildrenByItems(comparator);
                }
            }
        });
    }

    public static <KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> void sortByID(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super KEYTYPE> comparator) {
        ComparatorTreeItemID comparatorTreeItemID = new ComparatorTreeItemID(comparator);
        TreeWithIDSorter._sort(iBasicTree, comparatorTreeItemID);
    }

    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> void sortByID(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> iBasicTree) {
        ComparatorTreeItemIDComparable comparatorTreeItemIDComparable = new ComparatorTreeItemIDComparable();
        TreeWithIDSorter._sort(iBasicTree, comparatorTreeItemIDComparable);
    }

    public static <KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> void sortByValue(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super VALUETYPE> comparator) {
        ComparatorTreeItemValue comparatorTreeItemValue = new ComparatorTreeItemValue(comparator);
        TreeWithIDSorter._sort(iBasicTree, comparatorTreeItemValue);
    }

    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> void sortByValue(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> iBasicTree) {
        ComparatorTreeItemValueComparable comparatorTreeItemValueComparable = new ComparatorTreeItemValueComparable();
        TreeWithIDSorter._sort(iBasicTree, comparatorTreeItemValueComparable);
    }
}

