/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.cns.feeder.configuration;

import java.util.HashMap;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
@ComponentScan(basePackages={"fr.gouv.education.cns.feeder"})
@PropertySource(value={"classpath:workspaces.properties"})
public class FeederConfiguration {
    @Bean(name={"cnsContextSource"})
    public ContextSource getCnsContextSource() {
        HashMap<String, String> baseEnvironmentProperties = new HashMap<String, String>();
        baseEnvironmentProperties.put("com.sun.jndi.ldap.connect.timeout", System.getProperty("ldapSource.timeout"));
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(System.getProperty("ldapSource.url"));
        contextSource.setBase(System.getProperty("ldapSource.base"));
        contextSource.setUserDn(System.getProperty("ldapSource.manager.dn"));
        contextSource.setPassword(System.getProperty("ldapSource.manager.pswd"));
        contextSource.setPooled(true);
        contextSource.setBaseEnvironmentProperties(baseEnvironmentProperties);
        return contextSource;
    }

    @Bean(name={"cnsLdapTemplate"})
    public LdapTemplate getCnsLdapTemplate(@Qualifier(value="cnsContextSource") ContextSource contextSource) {
        return new LdapTemplate(contextSource);
    }

    @Bean
    public PersonUpdateService getPersonService() {
        return (PersonUpdateService)DirServiceFactory.getService(PersonUpdateService.class);
    }

    @Bean
    public WorkspaceService getWorkspaceService() {
        return (WorkspaceService)DirServiceFactory.getService(WorkspaceService.class);
    }
}

