/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.cns.feeder.controller;

import fr.gouv.education.cns.feeder.service.FeederService;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.servlet.http.HttpServletRequest;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class FeederController
extends GenericPortlet
implements ICustomizationModule {
    private static final String CUSTOMIZER_NAME = "cns.customizer.feeder";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private ICustomizationModulesRepository repository;
    @Autowired
    private PortletConfig portletConfig;
    @Autowired
    private FeederService service;
    private final CustomizationModuleMetadatas metadatas = this.generateMetadatas();

    private CustomizationModuleMetadatas generateMetadatas() {
        CustomizationModuleMetadatas metadatas = new CustomizationModuleMetadatas();
        metadatas.setName(CUSTOMIZER_NAME);
        metadatas.setModule((ICustomizationModule)this);
        metadatas.setCustomizationIDs(Arrays.asList("osivia.customizer.feeder.id"));
        return metadatas;
    }

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    @PreDestroy
    public void preDestroy() throws PortletException {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void customize(CustomizationContext customizationContext) {
        Map customizationAttributes = customizationContext.getAttributes();
        HttpServletRequest request = (HttpServletRequest)customizationAttributes.get("request");
        this.service.invoke(request);
    }
}

