/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.cns.feeder.dao;

import fr.gouv.education.cns.feeder.model.CnsSourcePerson;
import javax.naming.Name;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.support.LdapNameBuilder;
import org.springframework.stereotype.Repository;

@Repository
public class CnsSourcePersonDao {
    @Autowired
    @Qualifier(value="cnsLdapTemplate")
    private LdapTemplate cnsLdapTemplate;
    @Autowired
    private CnsSourcePerson sample;
    private final Name baseDn = LdapNameBuilder.newInstance((String)System.getProperty("ldapSource.base")).add("ou=personnes").build();

    public CnsSourcePerson getPerson(String uid) {
        LdapName dn = LdapNameBuilder.newInstance((Name)this.getBaseDn()).add("uid=" + Rdn.escapeValue(uid)).build();
        return (CnsSourcePerson)this.cnsLdapTemplate.findByDn((Name)dn, this.sample.getClass());
    }

    public Name getBaseDn() {
        return this.baseDn;
    }
}

