/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.cns.feeder.service;

import fr.gouv.education.cns.directory.v2.model.CnsPerson;
import fr.gouv.education.cns.feeder.dao.CnsSourcePersonDao;
import fr.gouv.education.cns.feeder.model.CnsSourcePerson;
import fr.gouv.education.cns.feeder.service.FeederService;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Name;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.directory.v2.model.ext.WorkspaceRole;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.directory.v2.model.Person;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Service
public class FeederServiceImpl
implements FeederService {
    @Autowired
    private Environment environment;
    @Autowired
    private CnsSourcePersonDao cnsPersonDao;
    @Autowired
    private PersonUpdateService personService;
    @Autowired
    private WorkspaceService workspaceService;
    private final Log log = LogFactory.getLog(this.getClass());

    public void invoke(HttpServletRequest request) {
        CnsSourcePerson sourcePerson;
        Element authentication = this.getAuthentication(request);
        String principalId = this.getPrincipalId(authentication);
        Map principalAttributes = this.getPrincipalAttributes(authentication);
        Name userDn = this.personService.getEmptyPerson().buildDn(principalId);
        Person person = this.personService.getPersonNoCache(userDn);
        if (person == null && (sourcePerson = this.cnsPersonDao.getPerson(principalId)) != null) {
            this.log.info((Object)("Cr\u00e9ation de la personne : " + sourcePerson.getCn()));
            person = this.toCnsPerson(sourcePerson);
            if (person != null) {
                String workspaceId;
                this.personService.create(person);
                String sharedWorkspaceId = this.environment.getProperty("COMMUN");
                this.log.info((Object)("Ajout \u00e0 l'espace commun : " + sharedWorkspaceId));
                this.workspaceService.addOrModifyMember(sharedWorkspaceId, person.getDn(), WorkspaceRole.WRITER);
                String entity = sourcePerson.getEntity();
                if (StringUtils.isNotBlank((String)entity) && StringUtils.isNotEmpty((String)(workspaceId = this.environment.getProperty(StringUtils.upperCase((String)entity))))) {
                    this.log.info((Object)("Ajout \u00e0 l'espace : " + sharedWorkspaceId));
                    this.workspaceService.addOrModifyMember(workspaceId, person.getDn(), WorkspaceRole.WRITER);
                }
            } else {
                this.log.error((Object)("Unable to create user " + userDn));
            }
        }
        if (person != null) {
            if ((person = this.personService.getPersonNoCache(person.getDn())).getExternal() == null) {
                boolean external = BooleanUtils.toBoolean((String)((String)principalAttributes.get("external")));
                person.setExternal(Boolean.valueOf(external));
            }
            person.setLastConnection(new Date());
            this.personService.update(person);
        }
    }

    private Element getAuthentication(HttpServletRequest request) {
        Element authentication;
        String casResponse = (String)request.getAttribute("casresponse");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            StringReader reader = new StringReader(casResponse);
            InputSource inputSource = new InputSource(reader);
            Document document = builder.parse(inputSource);
            authentication = (Element)document.getElementsByTagName("cas:serviceResponse").item(0);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        return authentication;
    }

    private String getPrincipalId(Element authentication) {
        return authentication.getElementsByTagName("cas:user").item(0).getTextContent();
    }

    private Map<String, String> getPrincipalAttributes(Element authentication) {
        HashMap<String, String> principalAttributes;
        NodeList casAttributesList = authentication.getElementsByTagName("cas:attributes");
        Node casAttributes = casAttributesList == null ? null : casAttributesList.item(0);
        if (casAttributes == null) {
            principalAttributes = new HashMap<String, String>(0);
        } else {
            int length = casAttributes.getChildNodes().getLength();
            principalAttributes = new HashMap(length);
            for (int i = 0; i < length; ++i) {
                String attributeName;
                Node casAttribute = casAttributes.getChildNodes().item(i);
                if (casAttribute.getNodeType() != 1 || !StringUtils.startsWith((String)(attributeName = casAttribute.getNodeName()), (String)"cas:")) continue;
                String key = StringUtils.removeStart((String)attributeName, (String)"cas:");
                String value = casAttribute.getTextContent();
                principalAttributes.put(key, value);
            }
        }
        return principalAttributes;
    }

    private CnsPerson toCnsPerson(CnsSourcePerson sourcePerson) {
        CnsPerson cnsPerson;
        String displayName = sourcePerson.getGivenName() + " " + sourcePerson.getSn();
        Person person = this.personService.getEmptyPerson();
        if (person != null && person instanceof CnsPerson) {
            cnsPerson = (CnsPerson)person;
            cnsPerson.setUid(sourcePerson.getUid());
            cnsPerson.setCn(displayName);
            cnsPerson.setDisplayName(displayName);
            cnsPerson.setGivenName(sourcePerson.getGivenName());
            cnsPerson.setMail(sourcePerson.getMail());
            cnsPerson.setSn(sourcePerson.getSn());
            String entity = sourcePerson.getEntity();
            if (StringUtils.isNotBlank((String)entity)) {
                cnsPerson.setEntity(StringUtils.upperCase((String)entity));
            }
        } else {
            cnsPerson = null;
        }
        return cnsPerson;
    }
}

