/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.impl;

import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.nuxeo.ecm.automation.client.adapters.BusinessServiceFactory;
import org.nuxeo.ecm.automation.client.adapters.DocumentServiceFactory;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpConnector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.AbstractAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.rest.api.RestClient;

public class HttpAutomationClient
extends AbstractAutomationClient {
    protected HttpClient http;
    protected int httpConnectionTimeout;

    public HttpAutomationClient(String url) {
        this(url, 0);
    }

    public HttpAutomationClient(String url, int httpConnectionTimeout) {
        super(url);
        this.init(httpConnectionTimeout);
    }

    private void init(int httpConnectionTimeout) {
        this.http = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
        this.httpConnectionTimeout = httpConnectionTimeout;
        this.registerAdapter(new DocumentServiceFactory());
        this.registerAdapter(new BusinessServiceFactory());
    }

    public void setProxy(String host, int port) {
        this.http.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(host, port));
    }

    public HttpClient http() {
        return this.http;
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        this.http.getConnectionManager().shutdown();
        this.http = null;
    }

    @Override
    protected Connector newConnector() {
        return new HttpConnector(this.http, this.httpConnectionTimeout);
    }

    public RestClient getRestClient() {
        return new RestClient(this);
    }
}

