/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.rest.api;

import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.CookieStore;
import org.apache.http.impl.client.BasicCookieStore;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.client.rest.api.RestRequest;

public class RestClient {
    protected static final String SITE_AUTOMATION_PATH_PATTERN = "(\\/api\\/v1)?(\\/site)?\\/automation";
    private static final Pattern SITE_AUTOMATION_PATH_PATTERN_COMPILED = Pattern.compile("(\\/api\\/v1)?(\\/site)?\\/automation", 2);
    protected static final String API_PATH = "/api/v1";
    WebResource service;

    public RestClient(HttpAutomationClient httpAutomationClient) {
        ApacheHttpClient4Handler handler = new ApacheHttpClient4Handler(httpAutomationClient.http(), (CookieStore)new BasicCookieStore(), false);
        ApacheHttpClient4 client = new ApacheHttpClient4(handler);
        if (httpAutomationClient.getRequestInterceptor() != null) {
            client.addFilter((ClientFilter)httpAutomationClient.getRequestInterceptor());
        }
        String apiURL = httpAutomationClient.getBaseUrl();
        apiURL = this.replaceAutomationEndpoint(apiURL);
        this.service = client.resource(apiURL);
    }

    private String replaceAutomationEndpoint(String url) {
        Matcher matcher = SITE_AUTOMATION_PATH_PATTERN_COMPILED.matcher(url);
        return matcher.replaceAll(API_PATH);
    }

    public RestRequest newRequest(String path) {
        return new RestRequest(this.service, path);
    }
}

