/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.bbb.portlet.service;

import fr.gouv.education.foad.bbb.portlet.form.VisioForm;
import fr.gouv.education.foad.bbb.portlet.service.CreateResponse;
import fr.gouv.education.foad.bbb.portlet.service.VisioException;
import fr.gouv.education.foad.bbb.portlet.service.VisioService;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

@Service
public class VisioServiceImpl
implements VisioService {
    private static final String DEFAULT_PW = "mp";
    @Value(value="#{systemProperties['foad.bbb.url'] ?: null}")
    private String url;
    @Value(value="#{systemProperties['foad.bbb.sharedsecret'] ?: null}")
    private String sharedSecret;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private Unmarshaller unmarshaller;
    @Autowired
    private PersonService personService;
    private final Log log = LogFactory.getLog(this.getClass());

    public VisioForm getForm(PortalControllerContext pcc) throws VisioException, PortletException {
        VisioForm bean = (VisioForm)this.context.getBean(VisioForm.class);
        NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)pcc.getRequest(), (PortletResponse)pcc.getResponse(), (PortletContext)pcc.getPortletCtx());
        Document doc = documentContext.getDoc();
        NuxeoController nuxeoController = new NuxeoController(pcc);
        nuxeoController.setCurrentDoc(doc);
        nuxeoController.insertContentMenuBarItems();
        String parentPath = StringUtils.substringBeforeLast((String)doc.getPath(), (String)"/");
        NuxeoDocumentContext parentDocumentContext = NuxeoController.getDocumentContext((PortalControllerContext)pcc, (String)parentPath);
        Document parentDoc = parentDocumentContext.getDoc();
        String meetingId = doc.getString("ttc:webid");
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("name", "TRIBU - " + parentDoc.getTitle()));
        parameters.add(new BasicNameValuePair("meetingID", meetingId));
        parameters.add(new BasicNameValuePair("moderatorPW", DEFAULT_PW));
        String callApi = this.prepareUrl("create", parameters);
        try {
            StringReader sr;
            CreateResponse response;
            String xmlResponse = this.getURL(callApi);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Appel BBB : " + callApi + "\n retour : " + xmlResponse));
            }
            if (!(response = (CreateResponse)this.unmarshaller.unmarshal((Reader)(sr = new StringReader(xmlResponse)))).getReturncode().equals("SUCCESS") && !response.getMessageKey().equals("idNotUnique")) {
                this.log.error((Object)"Erreur d'appel de l'API create");
                throw new VisioException();
            }
        }
        catch (RestClientException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Appel BBB : " + callApi + "\n retour : " + e.getMessage()));
            }
            return null;
        }
        catch (JAXBException e) {
            throw new PortletException((Throwable)e);
        }
        PortletRequest request = pcc.getRequest();
        String user = request.getRemoteUser();
        Person person = this.personService.getPerson(user);
        parameters = new ArrayList();
        parameters.add(new BasicNameValuePair("fullName", person.getDisplayName()));
        parameters.add(new BasicNameValuePair("meetingID", meetingId));
        parameters.add(new BasicNameValuePair("password", DEFAULT_PW));
        parameters.add(new BasicNameValuePair("role", "MODERATOR"));
        callApi = this.prepareUrl("join", parameters);
        bean.setUrl(callApi);
        return bean;
    }

    private String prepareUrl(String service, List<BasicNameValuePair> parameters) throws VisioException {
        if (StringUtils.isBlank((String)this.url) || StringUtils.isBlank((String)this.sharedSecret)) {
            this.log.error((Object)"Param\u00e8tres manquants bbb url ou sharedSecret");
            throw new VisioException();
        }
        String queryString = URLEncodedUtils.format(parameters, (String)"UTF-8");
        String checksum = DigestUtils.sha1Hex((String)(service + queryString + this.sharedSecret));
        parameters.add(new BasicNameValuePair("checksum", checksum));
        String queryStringWithChecksum = URLEncodedUtils.format(parameters, (String)"UTF-8");
        String getUrl = this.url + "/" + service + "?" + queryStringWithChecksum;
        return getUrl;
    }

    private String getURL(String url) throws PortletException {
        StringBuffer response = null;
        try {
            URL u = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)u.openConnection();
            httpConnection.setUseCaches(false);
            httpConnection.setDoOutput(true);
            httpConnection.setRequestMethod("GET");
            httpConnection.connect();
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                InputStream input = httpConnection.getInputStream();
                response = new StringBuffer();
                Reader reader = new InputStreamReader(input, "UTF-8");
                reader = new BufferedReader(reader);
                char[] buffer = new char[1024];
                int n = 0;
                while (n >= 0) {
                    n = reader.read(buffer, 0, buffer.length);
                    if (n <= 0) continue;
                    response.append(buffer, 0, n);
                }
                input.close();
                httpConnection.disconnect();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Erreur appel BBB");
            throw new PortletException((Throwable)e);
        }
        if (response != null) {
            return response.toString();
        }
        return "";
    }
}

