/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.customizer.attributes;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.theme.PageRendition;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.theming.IAttributesBundle;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public class CustomizedAttributesBundle
implements IAttributesBundle {
    private static final String FIM_URL_RETOUR = "freduurlretour";
    private static final String APPLICATIONS = "osivia.sso.applications";
    private static final String TOOLBAR_HELP_URL = "toolbar.help.url";
    private static final IAttributesBundle INSTANCE = new CustomizedAttributesBundle();
    private static final String PORTAL_LOGOUT = "/portal/logout";
    private final Set<String> names = new HashSet();
    private final List<String> applications;
    private final IPortalUrlFactory portalUrlFactory;

    private CustomizedAttributesBundle() {
        this.names.add(APPLICATIONS);
        this.names.add(TOOLBAR_HELP_URL);
        this.applications = new ArrayList();
        this.applications.add(NuxeoConnectionProperties.getPublicBaseUri().toString().concat("/logout"));
        this.applications.add(System.getProperty("cas.logout"));
        this.portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    }

    public static IAttributesBundle getInstance() {
        return INSTANCE;
    }

    public void fill(RenderPageCommand renderPageCommand, PageRendition pageRendition, Map<String, Object> attributes) throws ControllerException {
        String helpUrl;
        String headerUrlRetour;
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
        ArrayList<String> applisToLogout = new ArrayList<String>(this.applications);
        if (portalControllerContext != null && portalControllerContext.getHttpServletRequest() != null && StringUtils.isNotBlank((String)(headerUrlRetour = portalControllerContext.getHttpServletRequest().getHeader(FIM_URL_RETOUR)))) {
            String portalLogout = (String)attributes.get("osivia.toolbar.signOutURL");
            applisToLogout.add(portalLogout);
            attributes.put("osivia.toolbar.signOutURL", headerUrlRetour);
        }
        attributes.put(APPLICATIONS, applisToLogout);
        String helpPath = System.getProperty("help.path");
        if (StringUtils.isBlank((String)helpPath)) {
            helpUrl = null;
        } else {
            if (!StringUtils.startsWith((String)helpPath, (String)"/")) {
                helpPath = NuxeoController.webIdToCmsPath((String)helpPath);
            }
            helpUrl = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, helpPath, null, null, null, null, null, null, null);
        }
        attributes.put(TOOLBAR_HELP_URL, helpUrl);
    }

    public Set<String> getAttributeNames() {
        return this.names;
    }
}

