/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.controller.impl;

import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.io.Serialization;
import org.jboss.portal.common.io.SerializationFilter;
import org.jboss.portal.common.util.Base64;
import org.jboss.portal.portlet.ActionURL;
import org.jboss.portal.portlet.ContainerURL;
import org.jboss.portal.portlet.PortletURL;
import org.jboss.portal.portlet.RenderURL;
import org.jboss.portal.portlet.ResourceURL;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.cache.CacheLevel;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerRequestParameterMapFactory {
    private final Serialization<PortletPageNavigationalState> serialization;

    public ControllerRequestParameterMapFactory(Serialization<PortletPageNavigationalState> serialization) {
        this.serialization = serialization;
    }

    public Map<String, String> encode(PortletPageNavigationalState pageNS, String windowId, ContainerURL containerURL) {
        String type;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("windowid", windowId);
        if (containerURL instanceof ActionURL) {
            type = "action";
        } else if (containerURL instanceof RenderURL) {
            type = "render";
        } else if (containerURL instanceof ResourceURL) {
            type = "resource";
        } else {
            throw new Error();
        }
        parameters.put("phase", type);
        String pageNavigationalState = null;
        if (pageNS != null) {
            byte[] bytes = IOTools.serialize(this.serialization, (SerializationFilter)SerializationFilter.COMPRESSOR, (Object)pageNS);
            pageNavigationalState = Base64.encodeBytes((byte[])bytes, (boolean)true);
        }
        if (containerURL instanceof PortletURL) {
            PortletURL portletURL = (PortletURL)containerURL;
            if (portletURL.getMode() != null) {
                parameters.put("mode", portletURL.getMode().toString());
            }
            if (portletURL.getWindowState() != null) {
                parameters.put("windowstate", portletURL.getWindowState().toString());
            }
            if (pageNavigationalState != null) {
                parameters.put("pagenavigationalstate", pageNavigationalState);
            }
            if (containerURL instanceof ActionURL) {
                ActionURL actionURL = (ActionURL)containerURL;
                if (actionURL.getNavigationalState() != null) {
                    parameters.put("navigationalstate", actionURL.getNavigationalState().getStringValue());
                }
                StateString interactionState = actionURL.getInteractionState();
                parameters.put("interactionstate", interactionState.getStringValue());
            } else {
                RenderURL renderURL = (RenderURL)containerURL;
                Map changes = renderURL.getPublicNavigationalStateChanges();
                byte[] bytes = IOTools.serialize((Serialization)Serialization.PARAMETER_MAP, (SerializationFilter)SerializationFilter.COMPRESSOR, (Object)changes);
                String ns = Base64.encodeBytes((byte[])bytes, (boolean)true);
                parameters.put("publicnavigationalstatechanges", ns);
                StateString navigationalState = renderURL.getNavigationalState();
                if (navigationalState != null) {
                    parameters.put("navigationalstate", navigationalState.getStringValue());
                }
            }
        } else {
            ResourceURL resourceURL = (ResourceURL)containerURL;
            StateString resourceState = resourceURL.getResourceState();
            parameters.put("resourcestate", resourceState.getStringValue());
            String resourceId = resourceURL.getResourceId();
            if (resourceId != null) {
                parameters.put("resourceid", resourceId);
            }
            CacheLevel cacheability = resourceURL.getCacheability();
            parameters.put("resourcecacheability", cacheability.name());
            if (cacheability != CacheLevel.FULL) {
                if (resourceURL.getNavigationalState() != null) {
                    parameters.put("navigationalstate", resourceURL.getNavigationalState().getStringValue());
                }
                if (resourceURL.getMode() != null) {
                    parameters.put("mode", resourceURL.getMode().toString());
                }
                if (resourceURL.getWindowState() != null) {
                    parameters.put("windowstate", resourceURL.getWindowState().toString());
                }
                if (cacheability == CacheLevel.PAGE && pageNavigationalState != null) {
                    parameters.put("pagenavigationalstate", pageNavigationalState);
                }
            }
        }
        return parameters;
    }
}

